/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationManager;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.impl.ConnectionPool;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ServiceChannelInitializer;
import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyService
implements Closeable {
    private final ProxyConfiguration proxyConfig;
    private final String serviceUrl;
    private final String serviceUrlTls;
    private ConfigurationCacheService configurationCacheService;
    private AuthenticationService authenticationService;
    private AuthorizationManager authorizationManager;
    private ZooKeeperClientFactory zkClientFactory = null;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private final DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-discovery-acceptor");
    private final DefaultThreadFactory workersThreadFactory = new DefaultThreadFactory("pulsar-discovery-io");
    private final PulsarClientImpl client;
    private final Authentication clientAuthentication;
    private BrokerDiscoveryProvider discoveryProvider;
    private LocalZooKeeperConnectionService localZooKeeperConnectionService;
    private static final int numThreads = Runtime.getRuntime().availableProcessors();
    private static final Logger LOG = LoggerFactory.getLogger(ProxyService.class);

    public ProxyService(ProxyConfiguration proxyConfig) throws IOException {
        String hostname;
        Preconditions.checkNotNull((Object)proxyConfig);
        this.proxyConfig = proxyConfig;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.serviceUrl = String.format("pulsar://%s:%d/", hostname, proxyConfig.getServicePort());
        this.serviceUrlTls = String.format("pulsar://%s:%d/", hostname, proxyConfig.getServicePortTls());
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)1, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)numThreads, (ThreadFactory)this.workersThreadFactory);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxyConfig.getBrokerClientAuthenticationPlugin() != null) {
            clientConfiguration.setAuthentication(proxyConfig.getBrokerClientAuthenticationPlugin(), proxyConfig.getBrokerClientAuthenticationParameters());
        }
        this.client = new PulsarClientImpl(this.serviceUrl, clientConfiguration, this.workerGroup);
        this.clientAuthentication = clientConfiguration.getAuthentication();
    }

    public void start() throws Exception {
        this.localZooKeeperConnectionService = new LocalZooKeeperConnectionService(this.getZooKeeperClientFactory(), this.proxyConfig.getZookeeperServers(), (long)this.proxyConfig.getZookeeperSessionTimeoutMs());
        this.localZooKeeperConnectionService.start(new ZooKeeperSessionWatcher.ShutdownService(){

            public void shutdown(int exitCode) {
                LOG.error("Lost local ZK session. Shutting down the proxy");
                Runtime.getRuntime().halt(-1);
            }
        });
        this.discoveryProvider = new BrokerDiscoveryProvider(this.proxyConfig, this.getZooKeeperClientFactory());
        this.configurationCacheService = new ConfigurationCacheService((ZooKeeperCache)this.discoveryProvider.globalZkCache);
        ServiceConfiguration serviceConfiguration = this.createServiceConfiguration(this.proxyConfig);
        this.authenticationService = new AuthenticationService(serviceConfiguration);
        this.authorizationManager = new AuthorizationManager(serviceConfiguration, this.configurationCacheService);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        bootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, false));
        bootstrap.bind(this.proxyConfig.getServicePort()).sync();
        LOG.info("Started Pulsar Proxy at {}", (Object)this.serviceUrl);
        if (this.proxyConfig.isTlsEnabledInProxy()) {
            ServerBootstrap tlsBootstrap = bootstrap.clone();
            tlsBootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, true));
            tlsBootstrap.bind(this.proxyConfig.getServicePortTls()).sync();
            LOG.info("Started Pulsar TLS Proxy on port {}", (Object)this.proxyConfig.getWebServicePortTls());
        }
    }

    long newRequestId() {
        return this.client.newRequestId();
    }

    ConnectionPool getConnectionPool() {
        return this.client.getCnxPool();
    }

    public ZooKeeperClientFactory getZooKeeperClientFactory() {
        if (this.zkClientFactory == null) {
            this.zkClientFactory = new ZookeeperClientFactoryImpl();
        }
        return this.zkClientFactory;
    }

    public BrokerDiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.localZooKeeperConnectionService != null) {
            this.localZooKeeperConnectionService.close();
        }
        if (this.discoveryProvider != null) {
            this.discoveryProvider.close();
        }
        this.acceptorGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.client.close();
    }

    private ServiceConfiguration createServiceConfiguration(ProxyConfiguration config) {
        ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
        serviceConfiguration.setAuthenticationEnabled(config.isAuthenticationEnabled());
        serviceConfiguration.setAuthorizationEnabled(config.isAuthorizationEnabled());
        serviceConfiguration.setAuthenticationProviders(config.getAuthenticationProviders());
        serviceConfiguration.setProperties(config.getProperties());
        return serviceConfiguration;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public ProxyConfiguration getConfiguration() {
        return this.proxyConfig;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public Authentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    public ConfigurationCacheService getConfigurationCacheService() {
        return this.configurationCacheService;
    }

    public void setConfigurationCacheService(ConfigurationCacheService configurationCacheService) {
        this.configurationCacheService = configurationCacheService;
    }
}

