/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.apache.pulsar.proxy.server.WebServer;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ProxyServiceStarter {
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Parameter(names={"-zk", "--zookeeper-servers"}, description="Local zookeeper connection string")
    private String zookeeperServers = "";
    @Parameter(names={"-gzk", "--global-zookeeper-servers"}, description="Global zookeeper connection string")
    private String globalZookeeperServers = "";
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;
    private static final Logger log = LoggerFactory.getLogger(ProxyServiceStarter.class);

    public ProxyServiceStarter(String[] args) throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> log.error("Uncaught exception in thread {}: {}", new Object[]{thread.getName(), exception.getMessage(), exception}));
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.help || StringUtils.isBlank((CharSequence)this.configFile)) {
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            System.exit(-1);
        }
        ProxyConfiguration config = (ProxyConfiguration)PulsarConfigurationLoader.create((String)this.configFile, ProxyConfiguration.class);
        if (!StringUtils.isBlank((CharSequence)this.zookeeperServers)) {
            config.setZookeeperServers(this.zookeeperServers);
        }
        if (!StringUtils.isBlank((CharSequence)this.globalZookeeperServers)) {
            config.setGlobalZookeeperServers(this.globalZookeeperServers);
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getZookeeperServers()) ? 1 : 0) != 0, (Object)"zookeeperServers must be provided");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getGlobalZookeeperServers()) ? 1 : 0) != 0, (Object)"globalZookeeperServers must be provided");
        final ProxyService discoveryService = new ProxyService(config);
        final WebServer server = new WebServer(config);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    discoveryService.close();
                    server.stop();
                }
                catch (Exception e) {
                    log.warn("server couldn't stop gracefully {}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
        discoveryService.start();
        DefaultExports.initialize();
        server.addServlet("/metrics", new ServletHolder(MetricsServlet.class));
        server.start();
    }

    public static void main(String[] args) throws Exception {
        new ProxyServiceStarter(args);
    }
}

