/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private ProxyConfiguration serviceConfig;
    private ProxyService proxyService;
    private boolean enableTLS;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTLS) {
        this.serviceConfig = serviceConfig;
        this.proxyService = proxyService;
        this.enableTLS = enableTLS;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTLS) {
            File tlsCert = new File(this.serviceConfig.getTlsCertificateFilePath());
            File tlsKey = new File(this.serviceConfig.getTlsKeyFilePath());
            SslContextBuilder builder = SslContextBuilder.forServer((File)tlsCert, (File)tlsKey);
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            SslContext sslCtx = builder.clientAuth(ClientAuth.OPTIONAL).build();
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService));
    }
}

