/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.proxy.server.AdminProxyHandler;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.apache.pulsar.proxy.server.WebServer;
import org.apache.pulsar.proxy.stats.ProxyStats;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketPingPongServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceStarter {
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Deprecated
    @Parameter(names={"-zk", "--zookeeper-servers"}, description="Local zookeeper connection string, please use --metadata-store instead")
    private String zookeeperServers = "";
    @Parameter(names={"-md", "--metadata-store"}, description="Metadata Store service url. eg: zk:my-zk:2181")
    private String metadataStoreUrl = "";
    @Deprecated
    @Parameter(names={"-gzk", "--global-zookeeper-servers"}, description="Global zookeeper connection string, please use --configuration-metadata-store instead")
    private String globalZookeeperServers = "";
    @Deprecated
    @Parameter(names={"-cs", "--configuration-store-servers"}, description="Configuration store connection string, please use --configuration-metadata-store instead")
    private String configurationStoreServers = "";
    @Parameter(names={"-cms", "--configuration-metadata-store"}, description="The metadata store URL for the configuration data")
    private String configurationMetadataStoreUrl = "";
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;
    @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
    private boolean generateDocs = false;
    private ProxyConfiguration config;
    private ProxyService proxyService;
    private WebServer server;
    private static final Logger log = LoggerFactory.getLogger(ProxyServiceStarter.class);

    public ProxyServiceStarter(String[] args) throws Exception {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(FixedDateFormat.FixedFormat.ISO8601_OFFSET_DATE_TIME_HHMM.getPattern());
            Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> {
                System.out.printf("%s [%s] error Uncaught exception in thread %s: %s%n", dateFormat.format(new Date()), thread.getContextClassLoader(), thread.getName(), exception.getMessage());
                exception.printStackTrace(System.out);
            });
            JCommander jcommander = new JCommander();
            try {
                jcommander.addObject((Object)this);
                jcommander.parse(args);
                if (this.help || StringUtils.isBlank((CharSequence)this.configFile)) {
                    jcommander.usage();
                    return;
                }
                if (this.generateDocs) {
                    CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                    cmd.addCommand("proxy", (Object)this);
                    cmd.run(null);
                    System.exit(0);
                }
            }
            catch (Exception e) {
                jcommander.usage();
                System.exit(-1);
            }
            this.config = (ProxyConfiguration)PulsarConfigurationLoader.create((String)this.configFile, ProxyConfiguration.class);
            if (!StringUtils.isBlank((CharSequence)this.metadataStoreUrl)) {
                this.config.setMetadataStoreUrl(this.metadataStoreUrl);
            } else if (!StringUtils.isBlank((CharSequence)this.zookeeperServers)) {
                this.config.setMetadataStoreUrl(this.zookeeperServers);
            }
            if (!StringUtils.isBlank((CharSequence)this.globalZookeeperServers)) {
                this.config.setConfigurationMetadataStoreUrl(this.globalZookeeperServers);
            }
            if (!StringUtils.isBlank((CharSequence)this.configurationStoreServers)) {
                this.config.setConfigurationMetadataStoreUrl(this.configurationStoreServers);
            }
            if (!StringUtils.isBlank((CharSequence)this.configurationMetadataStoreUrl)) {
                this.config.setConfigurationMetadataStoreUrl(this.configurationMetadataStoreUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getBrokerServiceURL())) {
                Preconditions.checkArgument((boolean)this.config.getBrokerServiceURL().startsWith("pulsar://"), (Object)"brokerServiceURL must start with pulsar://");
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getBrokerServiceURLTLS())) {
                Preconditions.checkArgument((boolean)this.config.getBrokerServiceURLTLS().startsWith("pulsar+ssl://"), (Object)"brokerServiceURLTLS must start with pulsar+ssl://");
            }
            if (StringUtils.isBlank((CharSequence)this.config.getBrokerServiceURL()) && StringUtils.isBlank((CharSequence)this.config.getBrokerServiceURLTLS()) || this.config.isAuthorizationEnabled()) {
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.config.getMetadataStoreUrl()) ? 1 : 0) != 0, (Object)"metadataStoreUrl must be provided");
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.config.getConfigurationMetadataStoreUrl()) ? 1 : 0) != 0, (Object)"configurationMetadataStoreUrl must be provided");
            }
            if (!this.config.isTlsEnabledWithBroker() && StringUtils.isBlank((CharSequence)this.config.getBrokerWebServiceURL()) || this.config.isTlsEnabledWithBroker() && StringUtils.isBlank((CharSequence)this.config.getBrokerWebServiceURLTLS())) {
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.config.getMetadataStoreUrl()) ? 1 : 0) != 0, (Object)"metadataStoreUrl must be provided");
            }
        }
        catch (Exception e) {
            log.error("Failed to start pulsar proxy service. error msg " + e.getMessage(), (Throwable)e);
            throw new PulsarServerException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        ProxyServiceStarter serviceStarter = new ProxyServiceStarter(args);
        try {
            serviceStarter.start();
        }
        catch (Throwable t) {
            log.error("Failed to start proxy.", t);
            Runtime.getRuntime().halt(1);
        }
    }

    public void start() throws Exception {
        AuthenticationService authenticationService = new AuthenticationService(PulsarConfigurationLoader.convertFrom((PulsarConfiguration)this.config));
        this.proxyService = new ProxyService(this.config, authenticationService);
        this.server = new WebServer(this.config, authenticationService);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        this.proxyService.start();
        DefaultExports.initialize();
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return DirectMemoryUtils.jvmMaxDirectMemory();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        ProxyServiceStarter.addWebServerHandlers(this.server, this.config, this.proxyService, this.proxyService.getDiscoveryProvider());
        this.server.start();
    }

    public void close() {
        try {
            if (this.proxyService != null) {
                this.proxyService.close();
            }
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.warn("server couldn't stop gracefully {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void addWebServerHandlers(WebServer server, ProxyConfiguration config, ProxyService service, BrokerDiscoveryProvider discoveryProvider) throws Exception {
        PrometheusMetricsServlet metricsServlet;
        if (service != null && (metricsServlet = service.getMetricsServlet()) != null) {
            server.addServlet("/metrics", new ServletHolder((Servlet)metricsServlet), Collections.emptyList(), config.isAuthenticateMetricsEndpoint());
        }
        server.addRestResource("/", "statusFilePath", config.getStatusFilePath(), VipStatus.class);
        server.addRestResource("/proxy-stats", "pulsar-proxy", service, ProxyStats.class);
        AdminProxyHandler adminProxyHandler = new AdminProxyHandler(config, discoveryProvider);
        ServletHolder servletHolder = new ServletHolder((Servlet)adminProxyHandler);
        server.addServlet("/admin", servletHolder);
        server.addServlet("/lookup", servletHolder);
        for (ProxyConfiguration.HttpReverseProxyConfig httpReverseProxyConfig : config.getHttpReverseProxyConfigs()) {
            log.debug("Adding reverse proxy with config {}", (Object)httpReverseProxyConfig);
            ServletHolder proxyHolder = new ServletHolder(ProxyServlet.Transparent.class);
            proxyHolder.setInitParameter("proxyTo", httpReverseProxyConfig.getProxyTo());
            proxyHolder.setInitParameter("prefix", "/");
            server.addServlet(httpReverseProxyConfig.getPath(), proxyHolder);
        }
        if (service != null && service.getProxyAdditionalServlets() != null) {
            Collection additionalServletCollection = service.getProxyAdditionalServlets().getServlets().values();
            for (AdditionalServletWithClassLoader servletWithClassLoader : additionalServletCollection) {
                servletWithClassLoader.loadConfig((PulsarConfiguration)config);
                server.addServlet(servletWithClassLoader.getBasePath(), servletWithClassLoader.getServletHolder(), Collections.emptyList(), config.isAuthenticationEnabled());
                log.info("proxy add additional servlet basePath {} ", (Object)servletWithClassLoader.getBasePath());
            }
        }
        if (config.isWebSocketServiceEnabled()) {
            ServiceConfiguration serviceConfiguration = PulsarConfigurationLoader.convertFrom((PulsarConfiguration)config);
            serviceConfiguration.setBrokerClientTlsEnabled(config.isTlsEnabledWithBroker());
            WebSocketService webSocketService = new WebSocketService(ProxyServiceStarter.createClusterData(config), serviceConfiguration);
            webSocketService.start();
            WebSocketProducerServlet producerWebSocketServlet = new WebSocketProducerServlet(webSocketService);
            server.addServlet("/ws/producer", new ServletHolder((Servlet)producerWebSocketServlet));
            server.addServlet("/ws/v2/producer", new ServletHolder((Servlet)producerWebSocketServlet));
            WebSocketConsumerServlet consumerWebSocketServlet = new WebSocketConsumerServlet(webSocketService);
            server.addServlet("/ws/consumer", new ServletHolder((Servlet)consumerWebSocketServlet));
            server.addServlet("/ws/v2/consumer", new ServletHolder((Servlet)consumerWebSocketServlet));
            WebSocketReaderServlet readerWebSocketServlet = new WebSocketReaderServlet(webSocketService);
            server.addServlet("/ws/reader", new ServletHolder((Servlet)readerWebSocketServlet));
            server.addServlet("/ws/v2/reader", new ServletHolder((Servlet)readerWebSocketServlet));
            WebSocketPingPongServlet pingPongWebSocketServlet = new WebSocketPingPongServlet(webSocketService);
            server.addServlet("/ws/pingpong", new ServletHolder((Servlet)pingPongWebSocketServlet));
            server.addServlet("/ws/v2/pingpong", new ServletHolder((Servlet)pingPongWebSocketServlet));
        }
    }

    private static ClusterData createClusterData(ProxyConfiguration config) {
        if (StringUtils.isNotBlank((CharSequence)config.getBrokerServiceURL()) || StringUtils.isNotBlank((CharSequence)config.getBrokerServiceURLTLS())) {
            return ClusterData.builder().serviceUrl(config.getBrokerWebServiceURL()).serviceUrlTls(config.getBrokerWebServiceURLTLS()).brokerServiceUrl(config.getBrokerServiceURL()).brokerServiceUrlTls(config.getBrokerServiceURLTLS()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)config.getBrokerWebServiceURL()) || StringUtils.isNotBlank((CharSequence)config.getBrokerWebServiceURLTLS())) {
            return ClusterData.builder().serviceUrl(config.getBrokerWebServiceURL()).serviceUrlTls(config.getBrokerWebServiceURLTLS()).build();
        }
        return null;
    }

    @VisibleForTesting
    public ProxyConfiguration getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public WebServer getServer() {
        return this.server;
    }

    public ProxyService getProxyService() {
        return this.proxyService;
    }
}

