/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final String MATCH_ALL = "/*";
    private final Server server;
    private final WebExecutorThreadPool webServiceExecutor;
    private final AuthenticationService authenticationService;
    private final List<String> servletPaths = new ArrayList<String>();
    private final List<Handler> handlers = new ArrayList<Handler>();
    private final ProxyConfiguration config;
    protected int externalServicePort;
    private URI serviceURI = null;
    private ServerConnector connector;
    private ServerConnector connectorTls;
    private final FilterInitializer filterInitializer;
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);

    public WebServer(ProxyConfiguration config, AuthenticationService authenticationService) {
        this.webServiceExecutor = new WebExecutorThreadPool(config.getHttpNumThreads(), "pulsar-external-web", config.getHttpServerThreadPoolQueueSize());
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        if (config.getMaxHttpServerConnections() > 0) {
            this.server.addBean((Object)new ConnectionLimit(config.getMaxHttpServerConnections(), this.server));
        }
        this.authenticationService = authenticationService;
        this.config = config;
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setOutputBufferSize(config.getHttpOutputBufferSize());
        if (config.getWebServicePort().isPresent()) {
            this.externalServicePort = config.getWebServicePort().get();
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            this.connector.setHost(config.getBindAddress());
            this.connector.setPort(this.externalServicePort);
            connectors.add(this.connector);
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                Object sslCtxFactory = config.isTlsEnabledWithKeyStore() ? JettySslContextFactory.createServerSslContextWithKeystore((String)config.getWebServiceTlsProvider(), (String)config.getTlsKeyStoreType(), (String)config.getTlsKeyStore(), (String)config.getTlsKeyStorePassword(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustStoreType(), (String)config.getTlsTrustStore(), (String)config.getTlsTrustStorePassword(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), (long)config.getTlsCertRefreshCheckDurationSec()) : JettySslContextFactory.createServerSslContext((String)config.getWebServiceTlsProvider(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), (long)config.getTlsCertRefreshCheckDurationSec());
                this.connectorTls = new ServerConnector(this.server, sslCtxFactory);
                this.connectorTls.setPort(config.getWebServicePortTls().get().intValue());
                this.connectorTls.setHost(config.getBindAddress());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(config.getHttpServerAcceptQueueSize()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
        this.filterInitializer = new FilterInitializer(config, authenticationService);
    }

    public URI getServiceUri() {
        return this.serviceURI;
    }

    public void addServlet(String basePath, ServletHolder servletHolder) {
        this.addServlet(basePath, servletHolder, Collections.emptyList());
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes) {
        this.addServlet(basePath, servletHolder, attributes, true);
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes, boolean requireAuthentication) {
        this.addServlet(basePath, servletHolder, attributes, requireAuthentication, true);
    }

    private void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes, boolean requireAuthentication, boolean checkForExistingPaths) {
        Optional<String> existingPath;
        if (checkForExistingPaths && (existingPath = this.servletPaths.stream().filter(p -> p.startsWith(basePath)).findFirst()).isPresent()) {
            throw new IllegalArgumentException(String.format("Cannot add servlet at %s, path %s already exists", basePath, existingPath.get()));
        }
        this.servletPaths.add(basePath);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        for (Pair<String, Object> attribute : attributes) {
            context.setAttribute((String)attribute.getLeft(), attribute.getRight());
        }
        this.filterInitializer.addFilters(context, requireAuthentication);
        this.handlers.add((Handler)context);
    }

    public void addRestResource(String basePath, String attribute, Object attributeValue, Class<?> resourceClass) {
        this.addRestResource(basePath, attribute, attributeValue, resourceClass, true);
    }

    public void addRestResource(String basePath, String attribute, Object attributeValue, Class<?> resourceClass, boolean requireAuthentication) {
        ResourceConfig config = new ResourceConfig();
        config.register(resourceClass);
        config.register(JsonMapperProvider.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, Collections.singletonList(Pair.of((Object)attribute, (Object)attributeValue)), requireAuthentication, false);
    }

    public int getExternalServicePort() {
        return this.externalServicePort;
    }

    public void start() throws Exception {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)JettyRequestLogFactory.createRequestLogger());
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.server.setHandler((Handler)stats);
        try {
            this.server.start();
            Arrays.stream(this.server.getConnectors()).filter(c -> c instanceof ServerConnector).findFirst().ifPresent(c -> {
                this.externalServicePort = ((ServerConnector)c).getPort();
            });
            URI reportedURI = this.server.getURI();
            this.serviceURI = new URI(reportedURI.getScheme(), null, reportedURI.getHost(), reportedURI.getPort(), null, null, null);
        }
        catch (Exception e) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (Connector c2 : this.server.getConnectors()) {
                if (!(c2 instanceof ServerConnector)) continue;
                ports.add(((ServerConnector)c2).getPort());
            }
            throw new IOException("Failed to start HTTP server on ports " + ports, e);
        }
        log.info("Server started at end point {}", (Object)this.getServiceUri());
    }

    public void stop() throws Exception {
        this.server.stop();
        this.webServiceExecutor.stop();
        log.info("Server stopped successfully");
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(ProxyConfiguration config, AuthenticationService authenticationService) {
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder((Filter)new RateLimitingFilter(config.getHttpRequestsMaxPerSecond())));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder((Filter)new AuthenticationFilter(authenticationService));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WebServer.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }
    }
}

