/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import javax.servlet.Servlet;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.v1.WebSocketProxyStatsV1;
import org.apache.pulsar.websocket.admin.v2.WebSocketProxyStatsV2;
import org.apache.pulsar.websocket.service.ProxyServer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceStarter.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
            if (arguments.generateDocs && arguments.configFile != null) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("websocket", (Object)arguments);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            return;
        }
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Need to specify a configuration file");
        try {
            String configFile = args[0];
            log.info("Loading configuration from {}", (Object)configFile);
            WebSocketProxyConfiguration config = (WebSocketProxyConfiguration)PulsarConfigurationLoader.create((String)configFile, WebSocketProxyConfiguration.class);
            ProxyServer proxyServer = new ProxyServer(config);
            WebSocketService service = new WebSocketService(config);
            WebSocketServiceStarter.start(proxyServer, service);
        }
        catch (Exception e) {
            log.error("Failed to start WebSocket service", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    public static void start(ProxyServer proxyServer, WebSocketService service) throws Exception {
        proxyServer.addWebSocketServlet("/ws/producer", (Servlet)new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/consumer", (Servlet)new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/reader", (Servlet)new WebSocketReaderServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/producer", (Servlet)new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/consumer", (Servlet)new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/reader", (Servlet)new WebSocketReaderServlet(service));
        proxyServer.addRestResources("/admin", WebSocketProxyStatsV1.class.getPackage().getName(), "webProxyService", service);
        proxyServer.addRestResources("/admin/v2", WebSocketProxyStatsV2.class.getPackage().getName(), "webProxyService", service);
        proxyServer.addRestResources("/", VipStatus.class.getPackage().getName(), "statusFilePath", service.getConfig().getStatusFilePath());
        proxyServer.start();
        service.start();
    }

    private static class Arguments {
        @Parameter(description="config file")
        private String configFile = "";
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

