/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.stats;

import com.google.common.collect.Maps;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.websocket.WebSocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMetrics {
    private volatile long accumulatedYoungGcCount = 0L;
    private volatile long currentYoungGcCount = 0L;
    private volatile long accumulatedYoungGcTime = 0L;
    private volatile long currentYoungGcTime = 0L;
    private volatile long accumulatedOldGcCount = 0L;
    private volatile long currentOldGcCount = 0L;
    private volatile long accumulatedOldGcTime = 0L;
    private volatile long currentOldGcTime = 0L;
    private static final Logger log = LoggerFactory.getLogger(JvmMetrics.class);
    private static ObjectName youngGenName = null;
    private static ObjectName oldGenName = null;

    public JvmMetrics(WebSocketService service) {
        service.getExecutor().scheduleAtFixedRate(this::updateGcStats, 0L, 1L, TimeUnit.MINUTES);
    }

    public Metrics generate() {
        HashMap dimensionMap = Maps.newHashMap();
        dimensionMap.put("system", "jvm");
        Metrics m = Metrics.create((Map)dimensionMap);
        Runtime r = Runtime.getRuntime();
        m.put("jvm_heap_used", (Object)(r.totalMemory() - r.freeMemory()));
        m.put("jvm_max_memory", (Object)r.maxMemory());
        m.put("jvm_total_memory", (Object)r.totalMemory());
        m.put("jvm_max_direct_memory", (Object)PlatformDependent.maxDirectMemory());
        m.put("jvm_thread_cnt", (Object)this.getThreadCount());
        m.put("jvm_gc_young_pause", (Object)this.currentYoungGcTime);
        m.put("jvm_gc_young_count", (Object)this.currentYoungGcCount);
        m.put("jvm_gc_old_pause", (Object)this.currentOldGcTime);
        m.put("jvm_gc_old_count", (Object)this.currentOldGcCount);
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : PooledByteBufAllocator.DEFAULT.metric().directArenas()) {
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        m.put("proxy_default_pool_allocated", (Object)totalAllocated);
        m.put("proxy_default_pool_used", (Object)totalUsed);
        return m;
    }

    private void updateGcStats() {
        MBeanServer s = ManagementFactory.getPlatformMBeanServer();
        try {
            long newValueYoungGcCount = (Long)s.getAttribute(youngGenName, "CollectionCount");
            long newValueYoungGcTime = (Long)s.getAttribute(youngGenName, "CollectionTime");
            this.currentYoungGcCount = newValueYoungGcCount - this.accumulatedYoungGcCount;
            this.currentYoungGcTime = newValueYoungGcTime - this.accumulatedYoungGcTime;
            this.accumulatedYoungGcCount = newValueYoungGcCount;
            this.accumulatedYoungGcTime = newValueYoungGcTime;
            long newValueOldGcCount = (Long)s.getAttribute(oldGenName, "CollectionCount");
            long newValueOldGcTime = (Long)s.getAttribute(oldGenName, "CollectionTime");
            this.currentOldGcCount = newValueOldGcCount - this.accumulatedOldGcCount;
            this.currentOldGcTime = newValueOldGcTime - this.accumulatedOldGcTime;
            this.accumulatedOldGcCount = newValueOldGcCount;
            this.accumulatedOldGcTime = newValueOldGcTime;
        }
        catch (Exception e) {
            log.error("Failed to collect GC stats: {}", (Object)e.getMessage());
        }
    }

    private long getThreadCount() {
        ThreadGroup parentThreadGroup = Thread.currentThread().getThreadGroup();
        while (parentThreadGroup.getParent() != null) {
            parentThreadGroup = parentThreadGroup.getParent();
        }
        return parentThreadGroup.activeCount();
    }

    static {
        try {
            youngGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Young Generation");
            oldGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Old Generation");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

