/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.apache.qpid.protonj2.test.driver.codec.transport.HeartBeat;
import org.apache.qpid.protonj2.test.driver.codec.transport.PerformativeDescribedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FrameDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPTestDriver.class);
    public static final byte AMQP_FRAME_TYPE = 0;
    public static final byte SASL_FRAME_TYPE = 1;
    public static final int FRAME_SIZE_BYTES = 4;
    private final AMQPTestDriver driver;
    private final Codec codec = Codec.Factory.create();
    private FrameParserStage stage = new HeaderParsingStage();
    private final FrameSizeParsingStage frameSizeParser = new FrameSizeParsingStage();
    private final FrameBufferingStage frameBufferingStage = new FrameBufferingStage();
    private final FrameParserStage frameBodyParsingStage = new FrameBodyParsingStage();

    public FrameDecoder(AMQPTestDriver driver) {
        this.driver = driver;
    }

    public void ingest(ByteBuffer buffer) throws AssertionError {
        try {
            this.stage.parse(buffer);
        }
        catch (AssertionError ex) {
            this.transitionToErrorStage(ex);
            throw ex;
        }
        catch (Throwable throwable) {
            AssertionError error = new AssertionError("Frame decode failed.", throwable);
            this.transitionToErrorStage(error);
            throw error;
        }
    }

    public void resetToExpectingHeader() {
        this.stage = new HeaderParsingStage();
    }

    private FrameParserStage transitionToFrameSizeParsingStage() {
        this.stage = this.frameSizeParser.reset(0);
        return this.stage;
    }

    private FrameParserStage transitionToFrameBufferingStage(int frameSize) {
        this.stage = this.frameBufferingStage.reset(frameSize);
        return this.stage;
    }

    private FrameParserStage initializeFrameBodyParsingStage(int frameSize) {
        this.stage = this.frameBodyParsingStage.reset(frameSize);
        return this.stage;
    }

    private ParsingErrorStage transitionToErrorStage(AssertionError error) {
        if (!(this.stage instanceof ParsingErrorStage)) {
            this.stage = new ParsingErrorStage(error);
        }
        return (ParsingErrorStage)this.stage;
    }

    private class HeaderParsingStage
    implements FrameParserStage {
        private final byte[] headerBytes = new byte[8];
        private int headerByte;

        private HeaderParsingStage() {
        }

        @Override
        public void parse(ByteBuffer incoming) throws AssertionError {
            while (incoming.remaining() > 0 && this.headerByte < 8) {
                this.headerBytes[this.headerByte++] = incoming.get();
            }
            if (this.headerByte == 8) {
                AMQPHeader header = new AMQPHeader(this.headerBytes);
                FrameDecoder.this.transitionToFrameSizeParsingStage();
                if (header.isSaslHeader()) {
                    FrameDecoder.this.driver.handleHeader(AMQPHeader.getSASLHeader());
                } else {
                    FrameDecoder.this.driver.handleHeader(AMQPHeader.getAMQPHeader());
                }
            }
        }

        @Override
        public HeaderParsingStage reset(int frameSize) {
            this.headerByte = 0;
            return this;
        }
    }

    private static interface FrameParserStage {
        public void parse(ByteBuffer var1) throws AssertionError;

        public FrameParserStage reset(int var1);
    }

    private class FrameSizeParsingStage
    implements FrameParserStage {
        private int frameSize;
        private int multiplier = 4;

        private FrameSizeParsingStage() {
        }

        @Override
        public void parse(ByteBuffer input) throws AssertionError {
            while (input.remaining() > 0) {
                this.frameSize |= (input.get() & 0xFF) << --this.multiplier * 8;
                if (this.multiplier != 0) continue;
            }
            if (this.multiplier == 0) {
                this.validateFrameSize();
                int length = this.frameSize - 4;
                if (input.remaining() < length) {
                    FrameDecoder.this.transitionToFrameBufferingStage(length);
                } else {
                    FrameDecoder.this.initializeFrameBodyParsingStage(length);
                }
                FrameDecoder.this.stage.parse(input);
            }
        }

        private void validateFrameSize() throws AssertionError {
            if (this.frameSize < 8) {
                throw new AssertionError((Object)String.format("specified frame size %d smaller than minimum frame header size 8", this.frameSize));
            }
            if (this.frameSize > FrameDecoder.this.driver.getInboundMaxFrameSize()) {
                throw new AssertionError((Object)String.format("specified frame size %d larger than maximum frame size %d", this.frameSize, FrameDecoder.this.driver.getInboundMaxFrameSize()));
            }
        }

        @Override
        public FrameSizeParsingStage reset(int frameSize) {
            this.multiplier = 4;
            this.frameSize = frameSize;
            return this;
        }
    }

    private class FrameBufferingStage
    implements FrameParserStage {
        private ByteBuffer buffer;

        private FrameBufferingStage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(ByteBuffer input) throws AssertionError {
            if (input.remaining() < this.buffer.remaining()) {
                this.buffer.put(input);
            } else {
                int oldLimit = input.limit();
                try {
                    this.buffer.put(input.limit(input.position() + this.buffer.remaining())).flip();
                }
                finally {
                    input.limit(oldLimit);
                }
                FrameDecoder.this.initializeFrameBodyParsingStage(this.buffer.remaining());
                try {
                    FrameDecoder.this.stage.parse(this.buffer.asReadOnlyBuffer());
                }
                finally {
                    this.buffer = null;
                }
            }
        }

        @Override
        public FrameBufferingStage reset(int frameSize) {
            this.buffer = ByteBuffer.allocate(frameSize);
            return this;
        }
    }

    private class FrameBodyParsingStage
    implements FrameParserStage {
        private int frameSize;

        private FrameBodyParsingStage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(ByteBuffer input) throws AssertionError {
            int dataOffset = input.get() << 2 & 0x3FF;
            int frameSize = this.frameSize + 4;
            this.validateDataOffset(dataOffset, frameSize);
            int type = input.get() & 0xFF;
            short channel = input.getShort();
            if (dataOffset != 8) {
                input.position(input.position() + dataOffset - 8);
            }
            int frameBodySize = frameSize - dataOffset;
            ByteBuffer payload = null;
            DescribedType val = null;
            if (frameBodySize > 0) {
                int payloadSize;
                int decodedBytes;
                try {
                    decodedBytes = (int)FrameDecoder.this.codec.decode(input);
                }
                catch (Exception e) {
                    throw new AssertionError("Decoder failed reading remote input:", e);
                }
                Codec.DataType dataType = FrameDecoder.this.codec.type();
                if (dataType != Codec.DataType.DESCRIBED) {
                    throw new IllegalArgumentException("Frame body type expected to be " + String.valueOf((Object)Codec.DataType.DESCRIBED) + " but was: " + String.valueOf((Object)dataType));
                }
                try {
                    val = FrameDecoder.this.codec.getDescribedType();
                }
                finally {
                    FrameDecoder.this.codec.clear();
                }
                if (input.remaining() > 0 && (payloadSize = frameBodySize - decodedBytes) > 0) {
                    byte[] payloadBytes = new byte[payloadSize];
                    input.get(payloadBytes);
                    payload = ByteBuffer.wrap(payloadBytes);
                }
            } else {
                LOG.trace("{} Read: CH[{}] : {} [{}]", new Object[]{FrameDecoder.this.driver.getName(), channel, HeartBeat.INSTANCE, payload});
                FrameDecoder.this.transitionToFrameSizeParsingStage();
                FrameDecoder.this.driver.handleHeartbeat(frameSize, channel);
                return;
            }
            if (type == 0) {
                PerformativeDescribedType performative = (PerformativeDescribedType)val;
                LOG.trace("{} Read: CH[{}] : {} [{}]", new Object[]{FrameDecoder.this.driver.getName(), channel, performative, payload});
                FrameDecoder.this.transitionToFrameSizeParsingStage();
                FrameDecoder.this.driver.handlePerformative(frameSize, performative, channel, payload);
            } else if (type == 1) {
                SaslDescribedType performative = (SaslDescribedType)val;
                LOG.trace("{} Read: {} [{}]", new Object[]{FrameDecoder.this.driver.getName(), performative, payload});
                FrameDecoder.this.transitionToFrameSizeParsingStage();
                FrameDecoder.this.driver.handleSaslPerformative(frameSize, performative, channel, payload);
            } else {
                throw new AssertionError((Object)String.format("unknown frame type: %d", type));
            }
        }

        @Override
        public FrameBodyParsingStage reset(int frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        private void validateDataOffset(int dataOffset, int frameSize) {
            if (dataOffset < 8) {
                throw new AssertionError((Object)String.format("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8));
            }
            if (dataOffset > frameSize) {
                throw new AssertionError((Object)String.format("specified frame data offset %d larger than the frame size %d", dataOffset, frameSize));
            }
        }
    }

    private static class ParsingErrorStage
    implements FrameParserStage {
        private final AssertionError parsingError;

        public ParsingErrorStage(AssertionError parsingError) {
            this.parsingError = parsingError;
        }

        @Override
        public void parse(ByteBuffer input) throws AssertionError {
            throw this.parsingError;
        }

        @Override
        public ParsingErrorStage reset(int frameSize) {
            return this;
        }
    }
}

