/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ProtonTestServerOptions;
import org.apache.qpid.protonj2.test.driver.actions.ConnectionDropAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.apache.qpid.protonj2.test.driver.netty.NettyEventLoop;
import org.apache.qpid.protonj2.test.driver.netty.NettyIOBuilder;
import org.apache.qpid.protonj2.test.driver.netty.NettyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonTestServer
extends ProtonTestPeer {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonTestServer.class);
    private final AMQPTestDriver driver = new NettyAwareAMQPTestDriver(this::processDriverOutput, this::processDriverAssertion, this::eventLoop);
    private final NettyServer server;

    public ProtonTestServer() {
        this(new ProtonTestServerOptions());
    }

    @Override
    public String getPeerName() {
        return "Server";
    }

    public ProtonTestServer(ProtonTestServerOptions options) {
        this.server = NettyIOBuilder.createServer(options, this::processConnectionEstablished, this::processConnectionDropped, this::processChannelInput);
    }

    public void start() {
        this.checkClosed();
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start server", e);
        }
    }

    public URI getServerURI() {
        return this.getServerURI(null);
    }

    public URI getServerURI(String query) {
        this.checkClosed();
        try {
            return this.server.getConnectionURI(query);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get connection URI: ", e);
        }
    }

    @Override
    public ProtonTestPeer dropAfterLastHandler() {
        this.getDriver().addScriptedElement(new ConnectionDropAction(this));
        return this;
    }

    @Override
    public ProtonTestPeer dropAfterLastHandler(int delay) {
        this.getDriver().addScriptedElement(new ConnectionDropAction(this).afterDelay(delay));
        return this;
    }

    public boolean isAcceptingConnections() {
        return this.server.isAcceptingConnections();
    }

    public boolean isSecure() {
        return this.server.isSecureServer();
    }

    public boolean hasSecureConnection() {
        return this.server.hasSecureConnection();
    }

    public boolean isConnectionVerified() {
        return this.server.isPeerVerified();
    }

    public SSLEngine getConnectionSSLEngine() {
        return this.server.getConnectionSSLEngine();
    }

    public int getConnectionRemotePort() {
        return this.server.getClientPort();
    }

    public boolean isWSCompressionActive() {
        return this.server.isWSCompressionActive();
    }

    @Override
    public AMQPTestDriver getDriver() {
        return this.driver;
    }

    @Override
    protected void processPeerShutdownRequest() {
        try {
            this.server.stopAsync();
        }
        catch (Throwable e) {
            LOG.info("Error suppressed on server stop: ", e);
        }
    }

    @Override
    protected void processCloseConnectionRequest() {
        try {
            this.server.disconnectClient();
        }
        catch (Throwable e) {
            LOG.info("Error suppressed on server dropping connected client: ", e);
        }
    }

    @Override
    protected void processDriverOutput(ByteBuffer frame) {
        LOG.trace("AMQP Server Channel writing: {}", (Object)frame);
        this.server.write(frame);
    }

    @Override
    protected void processConnectionEstablished() {
        LOG.trace("AMQP Server has a client connected.");
        this.driver.handleConnectedEstablished();
    }

    @Override
    protected void processConnectionDropped() {
        LOG.trace("AMQP Server reports client connection dropped.");
        this.driver.handleConnectedDropped();
    }

    protected void processDriverAssertion(AssertionError error) {
        LOG.trace("AMQP Server Closing due to error: {}", (Object)((Throwable)((Object)error)).getMessage());
        this.close();
    }

    protected void processChannelInput(ByteBuffer input) {
        LOG.trace("AMQP Server Channel processing: {}", (Object)input);
        this.driver.accept(input);
    }

    protected NettyEventLoop eventLoop() {
        return this.server.eventLoop();
    }

    private final class NettyAwareAMQPTestDriver
    extends AMQPTestDriver {
        public NettyAwareAMQPTestDriver(Consumer<ByteBuffer> frameConsumer, Consumer<AssertionError> assertionConsumer, Supplier<NettyEventLoop> scheduler) {
            super(ProtonTestServer.this.getPeerName(), frameConsumer, assertionConsumer, scheduler);
        }

        @Override
        public void deferAMQPFrame(int channel, DescribedType performative, ByteBuffer payload, boolean splitWrite) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.deferAMQPFrame(channel, performative, payload, splitWrite);
            } else {
                loop.execute(() -> super.deferAMQPFrame(channel, performative, payload, splitWrite));
            }
        }

        @Override
        public void deferSaslFrame(int channel, DescribedType performative) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.deferSaslFrame(channel, performative);
            } else {
                loop.execute(() -> super.deferSaslFrame(channel, performative));
            }
        }

        @Override
        public void deferHeader(AMQPHeader header) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.deferHeader(header);
            } else {
                loop.execute(() -> super.deferHeader(header));
            }
        }

        @Override
        public void sendAMQPFrame(int channel, DescribedType performative, ByteBuffer payload, boolean splitWrite) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.sendAMQPFrame(channel, performative, payload, splitWrite);
            } else {
                loop.execute(() -> super.sendAMQPFrame(channel, performative, payload, splitWrite));
            }
        }

        @Override
        public void sendSaslFrame(int channel, DescribedType performative) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.sendSaslFrame(channel, performative);
            } else {
                loop.execute(() -> super.sendSaslFrame(channel, performative));
            }
        }

        @Override
        public void sendHeader(AMQPHeader header) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.sendHeader(header);
            } else {
                loop.execute(() -> super.sendHeader(header));
            }
        }

        @Override
        public void sendEmptyFrame(int channel) {
            NettyEventLoop loop = ProtonTestServer.this.server.eventLoop();
            if (loop.inEventLoop()) {
                super.sendEmptyFrame(channel);
            } else {
                loop.execute(() -> super.sendEmptyFrame(channel));
            }
        }
    }
}

