/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AMQPHeaderInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.AttachInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.BeginInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.CloseInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DeclareInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DetachInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DetachLastCoordinatorInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DischargeInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DispositionInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.EmptyFrameInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.EndInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.ExecuteUserCodeAction;
import org.apache.qpid.protonj2.test.driver.actions.FlowInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.OpenInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.RawBytesInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.SaslChallengeInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.SaslInitInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.SaslMechanismsInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.SaslOutcomeInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.SaslResponseInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.TransferInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Target;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslCode;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Coordinator;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.expectations.AMQPHeaderExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.AttachExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.BeginExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.CloseExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.ConnectionDropExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.DeclareExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.DetachExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.DischargeExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.DispositionExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.EmptyFrameExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.EndExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.FlowExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.OpenExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.SaslChallengeExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.SaslInitExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.SaslMechanismsExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.SaslOutcomeExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.SaslResponseExpectation;
import org.apache.qpid.protonj2.test.driver.expectations.TransferExpectation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;

public abstract class ScriptWriter {
    public abstract AMQPTestDriver getDriver();

    public AMQPHeaderExpectation expectAMQPHeader() {
        AMQPHeaderExpectation expecting = new AMQPHeaderExpectation(AMQPHeader.getAMQPHeader(), this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public OpenExpectation expectOpen() {
        OpenExpectation expecting = new OpenExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public CloseExpectation expectClose() {
        CloseExpectation expecting = new CloseExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public BeginExpectation expectBegin() {
        BeginExpectation expecting = new BeginExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public EndExpectation expectEnd() {
        EndExpectation expecting = new EndExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public AttachExpectation expectAttach() {
        AttachExpectation expecting = new AttachExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public DetachExpectation expectDetach() {
        DetachExpectation expecting = new DetachExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public FlowExpectation expectFlow() {
        FlowExpectation expecting = new FlowExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public TransferExpectation expectTransfer() {
        TransferExpectation expecting = new TransferExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public DispositionExpectation expectDisposition() {
        DispositionExpectation expecting = new DispositionExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public EmptyFrameExpectation expectEmptyFrame() {
        EmptyFrameExpectation expecting = new EmptyFrameExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public ConnectionDropExpectation expectConnectionToDrop() {
        ConnectionDropExpectation expecting = new ConnectionDropExpectation();
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public AttachExpectation expectCoordinatorAttach() {
        AttachExpectation expecting = new AttachExpectation(this.getDriver());
        expecting.withRole(Role.SENDER);
        expecting.withCoordinator(CoreMatchers.isA(Coordinator.class));
        expecting.withSource(CoreMatchers.notNullValue());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public DeclareExpectation expectDeclare() {
        DeclareExpectation expecting = new DeclareExpectation(this.getDriver());
        expecting.withHandle(CoreMatchers.notNullValue());
        expecting.withDeliveryId(CoreMatchers.notNullValue());
        expecting.withDeliveryTag(CoreMatchers.notNullValue());
        expecting.withMessageFormat(Matchers.oneOf((Object[])new Number[]{0, UnsignedInteger.ZERO}));
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public DischargeExpectation expectDischarge() {
        DischargeExpectation expecting = new DischargeExpectation(this.getDriver());
        expecting.withHandle(CoreMatchers.notNullValue());
        expecting.withDeliveryId(CoreMatchers.notNullValue());
        expecting.withDeliveryTag(CoreMatchers.notNullValue());
        expecting.withMessageFormat(Matchers.oneOf((Object[])new Number[]{0, UnsignedInteger.ZERO}));
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public AMQPHeaderExpectation expectSASLHeader() {
        AMQPHeaderExpectation expecting = new AMQPHeaderExpectation(AMQPHeader.getSASLHeader(), this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public SaslMechanismsExpectation expectSaslMechanisms() {
        SaslMechanismsExpectation expecting = new SaslMechanismsExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public SaslInitExpectation expectSaslInit() {
        SaslInitExpectation expecting = new SaslInitExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public SaslChallengeExpectation expectSaslChallenge() {
        SaslChallengeExpectation expecting = new SaslChallengeExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public SaslResponseExpectation expectSaslResponse() {
        SaslResponseExpectation expecting = new SaslResponseExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public SaslOutcomeExpectation expectSaslOutcome() {
        SaslOutcomeExpectation expecting = new SaslOutcomeExpectation(this.getDriver());
        this.getDriver().addScriptedElement(expecting);
        return expecting;
    }

    public AMQPHeaderInjectAction remoteHeader(byte[] header) {
        return new AMQPHeaderInjectAction(this.getDriver(), new AMQPHeader(header));
    }

    public AMQPHeaderInjectAction remoteHeader(AMQPHeader header) {
        return new AMQPHeaderInjectAction(this.getDriver(), header);
    }

    public AMQPHeaderInjectAction remoteAMQPHeader() {
        return new AMQPHeaderInjectAction(this.getDriver(), AMQPHeader.getAMQPHeader());
    }

    public AMQPHeaderInjectAction remoteSASLHeader() {
        return new AMQPHeaderInjectAction(this.getDriver(), AMQPHeader.getSASLHeader());
    }

    public OpenInjectAction remoteOpen() {
        return new OpenInjectAction(this.getDriver());
    }

    public CloseInjectAction remoteClose() {
        return new CloseInjectAction(this.getDriver());
    }

    public BeginInjectAction remoteBegin() {
        return new BeginInjectAction(this.getDriver());
    }

    public EndInjectAction remoteEnd() {
        return new EndInjectAction(this.getDriver());
    }

    public AttachInjectAction remoteAttach() {
        return new AttachInjectAction(this.getDriver());
    }

    public DetachInjectAction remoteDetach() {
        return new DetachInjectAction(this.getDriver());
    }

    public DetachInjectAction remoteDetachLastCoordinatorLink() {
        return new DetachLastCoordinatorInjectAction(this.getDriver());
    }

    public FlowInjectAction remoteFlow() {
        return new FlowInjectAction(this.getDriver());
    }

    public TransferInjectAction remoteTransfer() {
        return new TransferInjectAction(this.getDriver());
    }

    public DispositionInjectAction remoteDisposition() {
        return new DispositionInjectAction(this.getDriver());
    }

    public DeclareInjectAction remoteDeclare() {
        DeclareInjectAction declare = new DeclareInjectAction(this.getDriver());
        declare.withMessageFormat(0);
        return declare;
    }

    public DischargeInjectAction remoteDischarge() {
        DischargeInjectAction discharge = new DischargeInjectAction(this.getDriver());
        discharge.withMessageFormat(0);
        return discharge;
    }

    public EmptyFrameInjectAction remoteEmptyFrame() {
        return new EmptyFrameInjectAction(this.getDriver());
    }

    public RawBytesInjectAction remoteBytes() {
        return new RawBytesInjectAction(this.getDriver());
    }

    public SaslInitInjectAction remoteSaslInit() {
        return new SaslInitInjectAction(this.getDriver());
    }

    public SaslMechanismsInjectAction remoteSaslMechanisms() {
        return new SaslMechanismsInjectAction(this.getDriver());
    }

    public SaslChallengeInjectAction remoteSaslChallenge() {
        return new SaslChallengeInjectAction(this.getDriver());
    }

    public SaslResponseInjectAction remoteSaslResponse() {
        return new SaslResponseInjectAction(this.getDriver());
    }

    public SaslOutcomeInjectAction remoteSaslOutcome() {
        return new SaslOutcomeInjectAction(this.getDriver());
    }

    public void expectSASLAnonymousConnect() {
        this.expectSASLAnonymousConnect("ANONYMOUS");
    }

    public void expectSASLAnonymousConnect(String ... mechanisms) {
        if (!Arrays.asList(mechanisms).contains("ANONYMOUS")) {
            throw new AssertionError((Object)"The list of mechanisms must contain ANONYMOUS for this expectation to be valid.");
        }
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms(mechanisms).queue();
        this.expectSaslInit().withMechanism("ANONYMOUS");
        this.remoteSaslOutcome().withCode(SaslCode.OK).queue();
        this.expectAMQPHeader().respondWithAMQPHeader();
    }

    public void expectSASLPlainConnect(String username, String password) {
        this.expectSASLPlainConnect(username, password, "PLAIN");
    }

    public void expectSASLPlainConnect(String username, String password, String ... mechanisms) {
        if (!Arrays.asList(mechanisms).contains("PLAIN")) {
            throw new AssertionError((Object)"The list of mechanisms must contain PLAIN for this expectation to be valid.");
        }
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms(mechanisms).queue();
        this.expectSaslInit().withMechanism("PLAIN").withInitialResponse(this.saslPlainInitialResponse(username, password));
        this.remoteSaslOutcome().withCode(SaslCode.OK).queue();
        this.expectAMQPHeader().respondWithAMQPHeader();
    }

    public void expectSaslXOauth2Connect(String username, String password) {
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms("XOAUTH2").queue();
        this.expectSaslInit().withMechanism("XOAUTH2").withInitialResponse(this.saslXOauth2InitialResponse(username, password));
        this.remoteSaslOutcome().withCode(SaslCode.OK).queue();
        this.expectAMQPHeader().respondWithAMQPHeader();
    }

    public void expectFailingSASLPlainConnect(byte saslCode) {
        this.expectFailingSASLPlainConnect(saslCode, "PLAIN");
    }

    public void expectFailingSASLPlainConnect(byte saslCode, String ... offeredMechanisms) {
        if (!Arrays.asList(offeredMechanisms).contains("PLAIN")) {
            throw new AssertionError((Object)"Expected offered mechanisms that contains the PLAIN mechanism");
        }
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms(offeredMechanisms).queue();
        this.expectSaslInit().withMechanism("PLAIN");
        if (saslCode <= 0 || saslCode > SaslCode.SYS_TEMP.ordinal()) {
            throw new IllegalArgumentException("SASL Code should indicate a failure");
        }
        this.remoteSaslOutcome().withCode(SaslCode.valueOf(saslCode)).queue();
    }

    public void expectSaslExternalConnect() {
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms("EXTERNAL").queue();
        this.expectSaslInit().withMechanism("EXTERNAL").withInitialResponse(new byte[0]);
        this.remoteSaslOutcome().withCode(SaslCode.OK).queue();
        this.expectAMQPHeader().respondWithAMQPHeader();
    }

    public void expectSaslMechanismNegotiationFailure(String ... offeredMechanisms) {
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms(offeredMechanisms).queue();
    }

    public void expectSaslConnectThatAlwaysFailsAuthentication(String[] offeredMechanisms, String chosenMechanism) {
        this.expectSASLHeader().respondWithSASLHeader();
        this.remoteSaslMechanisms().withMechanisms(offeredMechanisms).queue();
        this.expectSaslInit().withMechanism(chosenMechanism);
        this.remoteSaslOutcome().withCode(SaslCode.AUTH).queue();
    }

    public void queueClientSaslAnonymousConnect() {
        this.remoteSASLHeader().queue();
        this.expectSASLHeader();
        this.expectSaslMechanisms().withSaslServerMechanism("ANONYMOUS");
        this.remoteSaslInit().withMechanism("ANONYMOUS").queue();
        this.expectSaslOutcome().withCode(SaslCode.OK);
        this.remoteAMQPHeader().queue();
        this.expectAMQPHeader();
    }

    public void triggerClientSaslAnonymousConnect() {
        this.expectSASLHeader();
        this.expectSaslMechanisms().withSaslServerMechanism("ANONYMOUS");
        this.remoteSaslInit().withMechanism("ANONYMOUS").queue();
        this.expectSaslOutcome().withCode(SaslCode.OK);
        this.remoteAMQPHeader().queue();
        this.expectAMQPHeader();
        this.remoteSASLHeader().now();
    }

    public void queueClientSaslPlainConnect(String username, String password) {
        this.remoteSASLHeader().queue();
        this.expectSASLHeader();
        this.expectSaslMechanisms().withSaslServerMechanism("PLAIN");
        this.remoteSaslInit().withMechanism("PLAIN").withInitialResponse(this.saslPlainInitialResponse(username, password)).queue();
        this.expectSaslOutcome().withCode(SaslCode.OK);
        this.remoteAMQPHeader().queue();
        this.expectAMQPHeader();
    }

    public void triggerClientSaslPlainConnect(String username, String password) {
        this.expectSASLHeader();
        this.expectSaslMechanisms().withSaslServerMechanism("PLAIN");
        this.remoteSaslInit().withMechanism("PLAIN").withInitialResponse(this.saslPlainInitialResponse(username, password)).queue();
        this.expectSaslOutcome().withCode(SaslCode.OK);
        this.remoteAMQPHeader().queue();
        this.expectAMQPHeader();
        this.remoteSASLHeader().now();
    }

    public byte[] saslPlainInitialResponse(String username, String password) {
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] initialResponse = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, initialResponse, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, initialResponse, 2 + usernameBytes.length, passwordBytes.length);
        return initialResponse;
    }

    public byte[] saslXOauth2InitialResponse(String username, String password) {
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] initialResponse = new byte[usernameBytes.length + passwordBytes.length + 20];
        System.arraycopy("user=".getBytes(StandardCharsets.US_ASCII), 0, initialResponse, 0, 5);
        System.arraycopy(usernameBytes, 0, initialResponse, 5, usernameBytes.length);
        initialResponse[5 + usernameBytes.length] = 1;
        System.arraycopy("auth=Bearer ".getBytes(StandardCharsets.US_ASCII), 0, initialResponse, 6 + usernameBytes.length, 12);
        System.arraycopy(passwordBytes, 0, initialResponse, 18 + usernameBytes.length, passwordBytes.length);
        initialResponse[initialResponse.length - 2] = 1;
        initialResponse[initialResponse.length - 1] = 1;
        return initialResponse;
    }

    public BeginInjectAction respondToLastBegin() {
        BeginInjectAction response = new BeginInjectAction(this.getDriver());
        SessionTracker session = this.getDriver().sessions().getLastRemotelyOpenedSession();
        if (session == null) {
            throw new IllegalStateException("Cannot create response to Begin before one has been received.");
        }
        response.withRemoteChannel(session.getRemoteChannel());
        return response;
    }

    public AttachInjectAction respondToLastAttach() {
        AttachInjectAction response = new AttachInjectAction(this.getDriver());
        SessionTracker session = this.getDriver().sessions().getLastRemotelyOpenedSession();
        LinkTracker link = session.getLastRemotelyOpenedLink();
        if (link == null) {
            throw new IllegalStateException("Cannot create response to Attach before one has been received.");
        }
        if (link.isLocallyAttached()) {
            throw new IllegalStateException("Cannot create response to Attach since a local Attach was already sent.");
        }
        response.onChannel(link.getSession().getLocalChannel());
        response.withName(link.getName());
        response.withRole(link.getRole());
        response.withSndSettleMode(link.getRemoteSenderSettleMode());
        response.withRcvSettleMode(link.getRemoteReceiverSettleMode());
        if (link.getRemoteSource() != null) {
            response.withSource(new Source(link.getRemoteSource()));
            if (Boolean.TRUE.equals(link.getRemoteSource().getDynamic())) {
                response.withSource().withAddress(UUID.randomUUID().toString());
            }
        }
        if (link.getRemoteTarget() != null) {
            response.withTarget(new Target(link.getRemoteTarget()));
            if (Boolean.TRUE.equals(link.getRemoteTarget().getDynamic())) {
                response.withTarget().withAddress(UUID.randomUUID().toString());
            }
        }
        if (link.getRemoteCoordinator() != null) {
            response.withTarget(new Coordinator(link.getRemoteCoordinator()));
        }
        if (response.getPerformative().getInitialDeliveryCount() == null && link.isSender()) {
            response.withInitialDeliveryCount(0L);
        }
        return response;
    }

    public ExecuteUserCodeAction execute(Runnable action) {
        return new ExecuteUserCodeAction(this.getDriver(), action);
    }

    public void fire(AMQPHeader header) {
        this.getDriver().sendHeader(header);
    }

    public void fireAMQP(DescribedType performative) {
        this.getDriver().sendAMQPFrame(0, performative, null);
    }

    public void fireSASL(DescribedType performative) {
        this.getDriver().sendSaslFrame(0, performative);
    }
}

