/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.DeferrableScriptedAction;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;

public abstract class AbstractPerformativeInjectAction<P extends DescribedType>
implements DeferrableScriptedAction {
    public static final int CHANNEL_UNSET = -1;
    private final AMQPTestDriver driver;
    private int channel = -1;
    private int delay = -1;
    private boolean splitWrite = false;
    private boolean deferred = false;

    public AbstractPerformativeInjectAction(AMQPTestDriver driver) {
        this.driver = driver;
    }

    @Override
    public final AbstractPerformativeInjectAction<P> now() {
        this.beforeActionPerformed(this.driver);
        if (this.deferred) {
            this.driver.deferAMQPFrame(this.channel, (DescribedType)this.getPerformative(), this.getPayload(), this.splitWrite);
        } else {
            this.driver.sendAMQPFrame(this.onChannel(), (DescribedType)this.getPerformative(), this.getPayload(), this.splitWrite);
        }
        return this;
    }

    @Override
    public final AbstractPerformativeInjectAction<P> later(int delay) {
        this.driver.afterDelay(delay, this);
        return this;
    }

    @Override
    public final AbstractPerformativeInjectAction<P> queue() {
        this.driver.addScriptedElement(this);
        return this;
    }

    @Override
    public AbstractPerformativeInjectAction<P> deferred() {
        this.deferred = true;
        return this;
    }

    @Override
    public boolean isDeffered() {
        return this.deferred;
    }

    @Override
    public final AbstractPerformativeInjectAction<P> perform(AMQPTestDriver driver) {
        if (this.afterDelay() <= 0) {
            return this.now();
        }
        driver.afterDelay(this.afterDelay(), new ScriptedAction(){

            @Override
            public ScriptedAction queue() {
                return this;
            }

            @Override
            public ScriptedAction perform(AMQPTestDriver driver) {
                return AbstractPerformativeInjectAction.this.now();
            }

            @Override
            public ScriptedAction now() {
                return this;
            }

            @Override
            public ScriptedAction later(int waitTime) {
                return this;
            }

            public String toString() {
                return AbstractPerformativeInjectAction.this.toString();
            }
        });
        return this;
    }

    public int onChannel() {
        return this.channel;
    }

    public int afterDelay() {
        return this.delay;
    }

    public AbstractPerformativeInjectAction<?> afterDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public AbstractPerformativeInjectAction<?> onChannel(int channel) {
        this.channel = channel;
        return this;
    }

    public AbstractPerformativeInjectAction<?> onChannel(UnsignedShort channel) {
        this.channel = channel.intValue();
        return this;
    }

    public boolean splitWrite() {
        return this.splitWrite;
    }

    public AbstractPerformativeInjectAction<?> splitWrite(boolean value) {
        this.splitWrite = value;
        return this;
    }

    public abstract P getPerformative();

    public ByteBuffer getPayload() {
        return null;
    }

    protected void beforeActionPerformed(AMQPTestDriver driver) {
    }
}

