/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDropAction
implements ScriptedAction {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDropAction.class);
    private final ProtonTestPeer peer;
    private int delay = -1;

    public ConnectionDropAction(ProtonTestPeer peer) {
        this.peer = peer;
    }

    @Override
    public ScriptedAction now() {
        LOG.info("Connection Drop Action closing test peer connection as scripted");
        this.peer.dropConnection();
        return this;
    }

    @Override
    public ScriptedAction later(int waitTime) {
        this.peer.getDriver().afterDelay(this.delay, this);
        return this;
    }

    @Override
    public ScriptedAction queue() {
        this.peer.getDriver().addScriptedElement(this);
        return this;
    }

    @Override
    public ScriptedAction perform(AMQPTestDriver driver) {
        if (this.afterDelay() > 0) {
            driver.afterDelay(this.afterDelay(), new ScriptedAction(){

                @Override
                public ScriptedAction queue() {
                    return this;
                }

                @Override
                public ScriptedAction perform(AMQPTestDriver driver) {
                    return ConnectionDropAction.this.now();
                }

                @Override
                public ScriptedAction now() {
                    return this;
                }

                @Override
                public ScriptedAction later(int waitTime) {
                    return this;
                }
            });
        } else {
            this.now();
        }
        return this;
    }

    public int afterDelay() {
        return this.delay;
    }

    public ConnectionDropAction afterDelay(int delay) {
        this.delay = delay;
        return this;
    }
}

