/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.Map;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Accepted;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Modified;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Rejected;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Released;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transactions.TransactionalState;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.Disposition;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;

public class DispositionInjectAction
extends AbstractPerformativeInjectAction<Disposition> {
    private final Disposition disposition = new Disposition();
    private final DeliveryStateBuilder stateBuilder = new DeliveryStateBuilder();

    public DispositionInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Disposition getPerformative() {
        return this.disposition;
    }

    public DispositionInjectAction withRole(boolean role) {
        this.disposition.setRole(role);
        return this;
    }

    public DispositionInjectAction withRole(Boolean role) {
        this.disposition.setRole(role);
        return this;
    }

    public DispositionInjectAction withRole(Role role) {
        this.disposition.setRole(role.getValue());
        return this;
    }

    public DispositionInjectAction withFirst(int first) {
        this.disposition.setFirst(UnsignedInteger.valueOf(first));
        return this;
    }

    public DispositionInjectAction withFirst(long first) {
        this.disposition.setFirst(UnsignedInteger.valueOf(first));
        return this;
    }

    public DispositionInjectAction withFirst(UnsignedInteger first) {
        this.disposition.setFirst(first);
        return this;
    }

    public DispositionInjectAction withLast(int last) {
        this.disposition.setLast(UnsignedInteger.valueOf(last));
        return this;
    }

    public DispositionInjectAction withLast(long last) {
        this.disposition.setLast(UnsignedInteger.valueOf(last));
        return this;
    }

    public DispositionInjectAction withLast(UnsignedInteger last) {
        this.disposition.setLast(last);
        return this;
    }

    public DispositionInjectAction withSettled(boolean settled) {
        this.disposition.setSettled(settled);
        return this;
    }

    public DeliveryStateBuilder withState() {
        return this.stateBuilder;
    }

    public DispositionInjectAction withState(DeliveryState state) {
        this.disposition.setState(state);
        return this;
    }

    public DispositionInjectAction withBatchable(boolean batchable) {
        this.disposition.setBatchable(batchable);
        return this;
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        SessionTracker session;
        if (this.onChannel() == -1) {
            session = driver.sessions().getLastLocallyOpenedSession();
            this.onChannel(session.getLocalChannel().intValue());
        } else {
            session = driver.sessions().getSessionFromLocalChannel(UnsignedShort.valueOf(this.onChannel()));
        }
        if (session != null) {
            session.handleLocalDisposition(this.disposition);
        }
    }

    public final class DeliveryStateBuilder {
        public DispositionInjectAction accepted() {
            DispositionInjectAction.this.withState(Accepted.getInstance());
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction released() {
            DispositionInjectAction.this.withState(Released.getInstance());
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction rejected() {
            DispositionInjectAction.this.withState(new Rejected());
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction rejected(String condition, String description) {
            DispositionInjectAction.this.withState(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description)));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction rejected(Symbol condition, String description) {
            DispositionInjectAction.this.withState(new Rejected().setError(new ErrorCondition(condition, description)));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction rejected(String condition, String description, Map<String, Object> info) {
            DispositionInjectAction.this.withState(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction rejected(Symbol condition, String description, Map<Symbol, Object> info) {
            DispositionInjectAction.this.withState(new Rejected().setError(new ErrorCondition(condition, description, info)));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction modified() {
            DispositionInjectAction.this.withState(new Modified());
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction modified(boolean failed) {
            DispositionInjectAction.this.withState(new Modified().setDeliveryFailed(failed));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction modified(boolean failed, boolean undeliverableHere) {
            DispositionInjectAction.this.withState(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere));
            return DispositionInjectAction.this;
        }

        public DispositionInjectAction modified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            DispositionInjectAction.this.withState(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere).setMessageAnnotations(TypeMapper.toSymbolKeyedMap(annotations)));
            return DispositionInjectAction.this;
        }

        public TransactionalStateBuilder transactional() {
            TransactionalStateBuilder builder = new TransactionalStateBuilder(DispositionInjectAction.this);
            DispositionInjectAction.this.withState(builder.getState());
            return builder;
        }
    }

    public static class TransactionalStateBuilder {
        private final DispositionInjectAction action;
        private final TransactionalState state = new TransactionalState();

        public TransactionalStateBuilder(DispositionInjectAction action) {
            this.action = action;
        }

        public TransactionalState getState() {
            return this.state;
        }

        public DispositionInjectAction also() {
            return this.action;
        }

        public DispositionInjectAction and() {
            return this.action;
        }

        public TransactionalStateBuilder withTxnId(byte[] txnId) {
            this.state.setTxnId(new Binary(txnId));
            return this;
        }

        public TransactionalStateBuilder withTxnId(Binary txnId) {
            this.state.setTxnId(txnId);
            return this;
        }

        public TransactionalStateBuilder withOutcome(DeliveryState outcome) {
            this.state.setOutcome(outcome);
            return this;
        }

        public TransactionalStateBuilder withAccepted() {
            this.withOutcome(Accepted.getInstance());
            return this;
        }

        public TransactionalStateBuilder withReleased() {
            this.withOutcome(Released.getInstance());
            return this;
        }

        public TransactionalStateBuilder withRejected() {
            this.withOutcome(new Rejected());
            return this;
        }

        public TransactionalStateBuilder withRejected(String condition, String description) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description)));
            return this;
        }

        public TransactionalStateBuilder withRejected(Symbol condition, String description) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(condition, description)));
            return this;
        }

        public TransactionalStateBuilder withRejected(String condition, String description, Map<String, Object> info) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
            return this;
        }

        public TransactionalStateBuilder withRejected(Symbol condition, String description, Map<Symbol, Object> info) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(condition, description, info)));
            return this;
        }

        public TransactionalStateBuilder withModified() {
            this.withOutcome(new Modified());
            return this;
        }

        public TransactionalStateBuilder withModified(boolean failed) {
            this.withOutcome(new Modified().setDeliveryFailed(failed));
            return this;
        }

        public TransactionalStateBuilder withModified(boolean failed, boolean undeliverableHere) {
            this.withOutcome(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere));
            return this;
        }

        public TransactionalStateBuilder withModified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            this.withOutcome(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere).setMessageAnnotations(TypeMapper.toSymbolKeyedMap(annotations)));
            return this;
        }
    }
}

