/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;

public class ScriptCompleteAction
implements ScriptedAction {
    protected final AMQPTestDriver driver;
    protected final CountDownLatch complete = new CountDownLatch(1);

    public ScriptCompleteAction(AMQPTestDriver driver) {
        this.driver = driver;
    }

    @Override
    public ScriptCompleteAction now() {
        this.complete.countDown();
        return this;
    }

    @Override
    public ScriptCompleteAction queue() {
        this.driver.addScriptedElement(this);
        return this;
    }

    @Override
    public ScriptCompleteAction later(int delay) {
        this.driver.afterDelay(delay, this);
        return this;
    }

    @Override
    public ScriptCompleteAction perform(AMQPTestDriver driver) {
        this.complete.countDown();
        return this;
    }

    public void await() throws InterruptedException {
        this.complete.await();
    }

    public void await(long timeout, TimeUnit units) throws InterruptedException {
        if (!this.complete.await(timeout, units)) {
            throw new AssertionError("Timed out waiting for scripted expectations to be met", new TimeoutException());
        }
    }
}

