/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Accepted;
import org.apache.qpid.protonj2.test.driver.codec.messaging.AmqpSequence;
import org.apache.qpid.protonj2.test.driver.codec.messaging.AmqpValue;
import org.apache.qpid.protonj2.test.driver.codec.messaging.ApplicationProperties;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Data;
import org.apache.qpid.protonj2.test.driver.codec.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Footer;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Header;
import org.apache.qpid.protonj2.test.driver.codec.messaging.MessageAnnotations;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Modified;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Properties;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Rejected;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Released;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transactions.TransactionalState;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;

public class TransferInjectAction
extends AbstractPerformativeInjectAction<Transfer> {
    private final Transfer transfer = new Transfer();
    private final DeliveryStateBuilder stateBuilder = new DeliveryStateBuilder();
    private ByteBuffer payload;
    private Header header;
    private DeliveryAnnotations deliveryAnnotations;
    private MessageAnnotations messageAnnotations;
    private Properties properties;
    private ApplicationProperties applicationProperties;
    private DescribedType body;
    private Footer footer;
    private boolean explicitlyNullDeliveryTag;

    public TransferInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Transfer getPerformative() {
        return this.transfer;
    }

    @Override
    public ByteBuffer getPayload() {
        if (this.payload == null) {
            this.payload = this.encodePayload();
        }
        return this.payload;
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        if (this.onChannel() == -1) {
            this.onChannel(driver.sessions().getLastLocallyOpenedSession().getLocalChannel().intValue());
        }
        if (this.transfer.getHandle() == null) {
            this.transfer.setHandle(driver.sessions().getLastLocallyOpenedSession().getLastOpenedSender().getHandle());
        }
        SessionTracker session = driver.sessions().getSessionFromLocalChannel(UnsignedShort.valueOf(this.onChannel()));
        if (this.transfer.getDeliveryTag() == null && !this.explicitlyNullDeliveryTag) {
            this.transfer.setDeliveryTag(new Binary(TransferInjectAction.generateUniqueDeliveryTag()));
        }
        if (session != null) {
            session.handleLocalTransfer(this.transfer, this.getPayload());
        }
    }

    public TransferInjectAction withHandle(long handle) {
        this.transfer.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public TransferInjectAction withDeliveryId(int deliveryId) {
        this.transfer.setDeliveryId(UnsignedInteger.valueOf(deliveryId));
        return this;
    }

    public TransferInjectAction withDeliveryId(long deliveryId) {
        this.transfer.setDeliveryId(UnsignedInteger.valueOf(deliveryId));
        return this;
    }

    public TransferInjectAction withDeliveryTag(byte[] deliveryTag) {
        this.explicitlyNullDeliveryTag = deliveryTag == null;
        this.transfer.setDeliveryTag(new Binary(deliveryTag));
        return this;
    }

    public TransferInjectAction withDeliveryTag(Binary deliveryTag) {
        this.explicitlyNullDeliveryTag = deliveryTag == null;
        this.transfer.setDeliveryTag(deliveryTag);
        return this;
    }

    public TransferInjectAction withNullDeliveryTag() {
        this.explicitlyNullDeliveryTag = true;
        this.transfer.setDeliveryTag(null);
        return this;
    }

    public TransferInjectAction withMessageFormat(int messageFormat) {
        this.transfer.setMessageFormat(UnsignedInteger.valueOf(messageFormat));
        return this;
    }

    public TransferInjectAction withMessageFormat(long messageFormat) {
        this.transfer.setMessageFormat(UnsignedInteger.valueOf(messageFormat));
        return this;
    }

    public TransferInjectAction withMessageFormat(UnsignedInteger messageFormat) {
        this.transfer.setMessageFormat(messageFormat);
        return this;
    }

    public TransferInjectAction withSettled(Boolean settled) {
        this.transfer.setSettled(settled);
        return this;
    }

    public TransferInjectAction withSettled(boolean settled) {
        this.transfer.setSettled(settled);
        return this;
    }

    public TransferInjectAction withMore(boolean more) {
        this.transfer.setMore(more);
        return this;
    }

    public TransferInjectAction withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.transfer.setRcvSettleMode(rcvSettleMode.getValue());
        return this;
    }

    public TransferInjectAction withState(DeliveryState state) {
        this.transfer.setState(state);
        return this;
    }

    public DeliveryStateBuilder withState() {
        return this.stateBuilder;
    }

    public TransferInjectAction withResume(boolean resume) {
        this.transfer.setResume(resume);
        return this;
    }

    public TransferInjectAction withAborted(boolean aborted) {
        this.transfer.setAborted(aborted);
        return this;
    }

    public TransferInjectAction withBatchable(boolean batchable) {
        this.transfer.setBatchable(batchable);
        return this;
    }

    public TransferInjectAction withPayload(byte[] payload) {
        this.payload = ByteBuffer.allocate(payload.length);
        this.payload.put(payload);
        this.payload.flip().asReadOnlyBuffer();
        return this;
    }

    public TransferInjectAction withPayload(ByteBuffer payload) {
        this.payload = payload;
        return this;
    }

    public HeaderBuilder withHeader() {
        return new HeaderBuilder();
    }

    public DeliveryAnnotationsBuilder withDeliveryAnnotations() {
        return new DeliveryAnnotationsBuilder();
    }

    public MessageAnnotationsBuilder withMessageAnnotations() {
        return new MessageAnnotationsBuilder();
    }

    public PropertiesBuilder withProperties() {
        return new PropertiesBuilder();
    }

    public ApplicationPropertiesBuilder withApplicationProperties() {
        return new ApplicationPropertiesBuilder();
    }

    public BodySectionBuilder withBody() {
        return new BodySectionBuilder();
    }

    public FooterBuilder withFooter() {
        return new FooterBuilder();
    }

    public MessageBuilder withMessage() {
        return new MessageBuilder();
    }

    private Header getOrCreateHeader() {
        if (this.header == null) {
            this.header = new Header();
        }
        return this.header;
    }

    private DeliveryAnnotations getOrCreateDeliveryAnnotations() {
        if (this.deliveryAnnotations == null) {
            this.deliveryAnnotations = new DeliveryAnnotations();
        }
        return this.deliveryAnnotations;
    }

    private MessageAnnotations getOrCreateMessageAnnotations() {
        if (this.messageAnnotations == null) {
            this.messageAnnotations = new MessageAnnotations();
        }
        return this.messageAnnotations;
    }

    private Properties getOrCreateProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    private ApplicationProperties getOrCreateApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = new ApplicationProperties();
        }
        return this.applicationProperties;
    }

    private Footer getOrCreateFooter() {
        if (this.footer == null) {
            this.footer = new Footer();
        }
        return this.footer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer encodePayload() {
        Codec codec = Codec.Factory.create();
        try (ByteArrayOutputStream baOS = new ByteArrayOutputStream(128);){
            ByteBuffer byteBuffer;
            try (DataOutputStream output = new DataOutputStream(baOS);){
                if (this.header != null) {
                    codec.putDescribedType(this.header);
                }
                if (this.deliveryAnnotations != null) {
                    codec.putDescribedType(this.deliveryAnnotations);
                }
                if (this.messageAnnotations != null) {
                    codec.putDescribedType(this.messageAnnotations);
                }
                if (this.properties != null) {
                    codec.putDescribedType(this.properties);
                }
                if (this.applicationProperties != null) {
                    codec.putDescribedType(this.applicationProperties);
                }
                if (this.body != null) {
                    codec.putDescribedType(this.body);
                }
                if (this.footer != null) {
                    codec.putDescribedType(this.footer);
                }
                codec.encode(output);
                byte[] encodedBytes = baOS.toByteArray();
                byteBuffer = ByteBuffer.wrap(encodedBytes);
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] generateUniqueDeliveryTag() {
        byte[] tag = new byte[16];
        UUID uuid = UUID.randomUUID();
        TransferInjectAction.writeLong(uuid.getMostSignificantBits(), tag, 0);
        TransferInjectAction.writeLong(uuid.getLeastSignificantBits(), tag, 8);
        return tag;
    }

    private static byte[] writeLong(long value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 56);
        destination[offset++] = (byte)(value >>> 48);
        destination[offset++] = (byte)(value >>> 40);
        destination[offset++] = (byte)(value >>> 32);
        destination[offset++] = (byte)(value >>> 24);
        destination[offset++] = (byte)(value >>> 16);
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public final class DeliveryStateBuilder {
        public TransferInjectAction accepted() {
            TransferInjectAction.this.withState(Accepted.getInstance());
            return TransferInjectAction.this;
        }

        public TransferInjectAction released() {
            TransferInjectAction.this.withState(Released.getInstance());
            return TransferInjectAction.this;
        }

        public TransferInjectAction rejected() {
            TransferInjectAction.this.withState(new Rejected());
            return TransferInjectAction.this;
        }

        public TransferInjectAction rejected(String condition, String description) {
            TransferInjectAction.this.withState(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description)));
            return TransferInjectAction.this;
        }

        public TransferInjectAction rejected(Symbol condition, String description) {
            TransferInjectAction.this.withState(new Rejected().setError(new ErrorCondition(condition, description)));
            return TransferInjectAction.this;
        }

        public TransferInjectAction rejected(String condition, String description, Map<String, Object> info) {
            TransferInjectAction.this.withState(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
            return TransferInjectAction.this;
        }

        public TransferInjectAction rejected(Symbol condition, String description, Map<Symbol, Object> info) {
            TransferInjectAction.this.withState(new Rejected().setError(new ErrorCondition(condition, description, info)));
            return TransferInjectAction.this;
        }

        public TransferInjectAction modified() {
            TransferInjectAction.this.withState(new Modified());
            return TransferInjectAction.this;
        }

        public TransferInjectAction modified(boolean failed) {
            TransferInjectAction.this.withState(new Modified().setDeliveryFailed(failed));
            return TransferInjectAction.this;
        }

        public TransferInjectAction modified(boolean failed, boolean undeliverableHere) {
            TransferInjectAction.this.withState(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere));
            return TransferInjectAction.this;
        }

        public TransferInjectAction modified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            TransferInjectAction.this.withState(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere).setMessageAnnotations(TypeMapper.toSymbolKeyedMap(annotations)));
            return TransferInjectAction.this;
        }

        public TransactionalStateBuilder transactional() {
            TransactionalStateBuilder builder = new TransactionalStateBuilder(TransferInjectAction.this);
            TransferInjectAction.this.withState(builder.getState());
            return builder;
        }
    }

    public final class HeaderBuilder
    extends SectionBuilder {
        public HeaderBuilder withDurability(boolean durable) {
            TransferInjectAction.this.getOrCreateHeader().setDurable(durable);
            return this;
        }

        public HeaderBuilder withPriority(byte priority) {
            TransferInjectAction.this.getOrCreateHeader().setPriority(UnsignedByte.valueOf(priority));
            return this;
        }

        public HeaderBuilder withTimeToLive(long ttl) {
            TransferInjectAction.this.getOrCreateHeader().setTtl(UnsignedInteger.valueOf(ttl));
            return this;
        }

        public HeaderBuilder withFirstAcquirer(boolean first) {
            TransferInjectAction.this.getOrCreateHeader().setFirstAcquirer(first);
            return this;
        }

        public HeaderBuilder withDeliveryCount(long count) {
            TransferInjectAction.this.getOrCreateHeader().setDeliveryCount(UnsignedInteger.valueOf(count));
            return this;
        }
    }

    public final class DeliveryAnnotationsBuilder
    extends SectionBuilder {
        public DeliveryAnnotationsBuilder withAnnotation(String key, Object value) {
            TransferInjectAction.this.getOrCreateDeliveryAnnotations().setSymbolKeyedAnnotation(key, value);
            return this;
        }

        public DeliveryAnnotationsBuilder withAnnotation(Symbol key, Object value) {
            TransferInjectAction.this.getOrCreateDeliveryAnnotations().setSymbolKeyedAnnotation(key, value);
            return this;
        }
    }

    public final class MessageAnnotationsBuilder
    extends SectionBuilder {
        public MessageAnnotationsBuilder withAnnotation(String key, Object value) {
            TransferInjectAction.this.getOrCreateMessageAnnotations().setSymbolKeyedAnnotation(key, value);
            return this;
        }

        public MessageAnnotationsBuilder withAnnotation(Symbol key, Object value) {
            TransferInjectAction.this.getOrCreateMessageAnnotations().setSymbolKeyedAnnotation(key, value);
            return this;
        }
    }

    public final class PropertiesBuilder
    extends SectionBuilder {
        public PropertiesBuilder withMessageId(Object value) {
            TransferInjectAction.this.getOrCreateProperties().setMessageId(value);
            return this;
        }

        public PropertiesBuilder withUserID(Binary value) {
            TransferInjectAction.this.getOrCreateProperties().setUserId(value);
            return this;
        }

        public PropertiesBuilder withTo(String value) {
            TransferInjectAction.this.getOrCreateProperties().setTo(value);
            return this;
        }

        public PropertiesBuilder withSubject(String value) {
            TransferInjectAction.this.getOrCreateProperties().setSubject(value);
            return this;
        }

        public PropertiesBuilder withReplyTp(String value) {
            TransferInjectAction.this.getOrCreateProperties().setReplyTo(value);
            return this;
        }

        public PropertiesBuilder withCorrelationId(Object value) {
            TransferInjectAction.this.getOrCreateProperties().setCorrelationId(value);
            return this;
        }

        public PropertiesBuilder withContentType(String value) {
            TransferInjectAction.this.getOrCreateProperties().setContentType(Symbol.valueOf(value));
            return this;
        }

        public PropertiesBuilder withContentType(Symbol value) {
            TransferInjectAction.this.getOrCreateProperties().setContentType(value);
            return this;
        }

        public PropertiesBuilder withContentEncoding(String value) {
            TransferInjectAction.this.getOrCreateProperties().setContentEncoding(Symbol.valueOf(value));
            return this;
        }

        public PropertiesBuilder withContentEncoding(Symbol value) {
            TransferInjectAction.this.getOrCreateProperties().setContentEncoding(value);
            return this;
        }

        public PropertiesBuilder withAbsoluteExpiryTime(long value) {
            TransferInjectAction.this.getOrCreateProperties().setAbsoluteExpiryTime(new Date(value));
            return this;
        }

        public PropertiesBuilder withCreationTime(long value) {
            TransferInjectAction.this.getOrCreateProperties().setCreationTime(new Date(value));
            return this;
        }

        public PropertiesBuilder withGroupId(String value) {
            TransferInjectAction.this.getOrCreateProperties().setGroupId(value);
            return this;
        }

        public PropertiesBuilder withGroupSequence(long value) {
            TransferInjectAction.this.getOrCreateProperties().setGroupSequence(UnsignedInteger.valueOf(value));
            return this;
        }

        public PropertiesBuilder withReplyToGroupId(String value) {
            TransferInjectAction.this.getOrCreateProperties().setReplyToGroupId(value);
            return this;
        }
    }

    public final class ApplicationPropertiesBuilder
    extends SectionBuilder {
        public ApplicationPropertiesBuilder withProperty(String key, Object value) {
            TransferInjectAction.this.getOrCreateApplicationProperties().setApplicationProperty(key, value);
            return this;
        }

        public ApplicationPropertiesBuilder withApplicationProperty(String key, Object value) {
            TransferInjectAction.this.getOrCreateApplicationProperties().setApplicationProperty(key, value);
            return this;
        }
    }

    public final class BodySectionBuilder
    extends SectionBuilder {
        public BodySectionBuilder withString(String body) {
            TransferInjectAction.this.body = new AmqpValue(body);
            return this;
        }

        public BodySectionBuilder withValue(String body) {
            TransferInjectAction.this.body = new AmqpValue(body);
            return this;
        }

        public BodySectionBuilder withValue(Map<?, ?> body) {
            TransferInjectAction.this.body = new AmqpValue(body);
            return this;
        }

        public BodySectionBuilder withValue(Object body) {
            TransferInjectAction.this.body = new AmqpValue(body);
            return this;
        }

        public BodySectionBuilder withValue(byte[] body) {
            TransferInjectAction.this.body = new AmqpValue(body == null ? null : new Binary(body));
            return this;
        }

        public BodySectionBuilder withValue(Binary body) {
            TransferInjectAction.this.body = new Data(body);
            return this;
        }

        public BodySectionBuilder withData(byte[] body) {
            TransferInjectAction.this.body = new Data(body == null ? null : new Binary(body));
            return this;
        }

        public BodySectionBuilder withData(Binary body) {
            TransferInjectAction.this.body = new Data(body);
            return this;
        }

        public BodySectionBuilder withSequence(List<Object> sequence) {
            TransferInjectAction.this.body = new AmqpSequence(sequence);
            return this;
        }

        public BodySectionBuilder withDescribed(DescribedType described) {
            TransferInjectAction.this.body = new AmqpValue(described);
            return this;
        }
    }

    public final class FooterBuilder
    extends SectionBuilder {
        public FooterBuilder withFooter(String key, Object value) {
            TransferInjectAction.this.getOrCreateFooter().setFooterProperty(Symbol.valueOf(key), value);
            return this;
        }

        public FooterBuilder withFooter(Symbol key, Object value) {
            TransferInjectAction.this.getOrCreateFooter().setFooterProperty(key, value);
            return this;
        }
    }

    public final class MessageBuilder
    extends SectionBuilder {
        public MessageBuilder withMessageFormat(int format) {
            TransferInjectAction.this.withMessageFormat(format);
            return this;
        }

        public HeaderBuilder withHeader() {
            return TransferInjectAction.this.withHeader();
        }

        public DeliveryAnnotationsBuilder withDeliveryAnnotations() {
            return TransferInjectAction.this.withDeliveryAnnotations();
        }

        public MessageAnnotationsBuilder withMessageAnnotations() {
            return TransferInjectAction.this.withMessageAnnotations();
        }

        public PropertiesBuilder withProperties() {
            return TransferInjectAction.this.withProperties();
        }

        public ApplicationPropertiesBuilder withApplicationProperties() {
            return TransferInjectAction.this.withApplicationProperties();
        }

        public BodySectionBuilder withBody() {
            return TransferInjectAction.this.withBody();
        }

        public FooterBuilder withFooter() {
            return TransferInjectAction.this.withFooter();
        }
    }

    public static class TransactionalStateBuilder {
        private final TransferInjectAction action;
        private final TransactionalState state = new TransactionalState();

        public TransactionalStateBuilder(TransferInjectAction action) {
            this.action = action;
        }

        public TransactionalState getState() {
            return this.state;
        }

        public TransferInjectAction also() {
            return this.action;
        }

        public TransferInjectAction and() {
            return this.action;
        }

        public TransactionalStateBuilder withTxnId(byte[] txnId) {
            this.state.setTxnId(new Binary(txnId));
            return this;
        }

        public TransactionalStateBuilder withTxnId(Binary txnId) {
            this.state.setTxnId(txnId);
            return this;
        }

        public TransactionalStateBuilder withOutcome(DeliveryState outcome) {
            this.state.setOutcome(outcome);
            return this;
        }

        public TransactionalStateBuilder withAccepted() {
            this.withOutcome(Accepted.getInstance());
            return this;
        }

        public TransactionalStateBuilder withReleased() {
            this.withOutcome(Released.getInstance());
            return this;
        }

        public TransactionalStateBuilder withRejected() {
            this.withOutcome(new Rejected());
            return this;
        }

        public TransactionalStateBuilder withRejected(String condition, String description) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description)));
            return this;
        }

        public TransactionalStateBuilder withRejected(Symbol condition, String description) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(condition, description)));
            return this;
        }

        public TransactionalStateBuilder withRejected(String condition, String description, Map<String, Object> info) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
            return this;
        }

        public TransactionalStateBuilder withRejected(Symbol condition, String description, Map<Symbol, Object> info) {
            this.withOutcome(new Rejected().setError(new ErrorCondition(condition, description, info)));
            return this;
        }

        public TransactionalStateBuilder withModified() {
            this.withOutcome(new Modified());
            return this;
        }

        public TransactionalStateBuilder withModified(boolean failed) {
            this.withOutcome(new Modified().setDeliveryFailed(failed));
            return this;
        }

        public TransactionalStateBuilder withModified(boolean failed, boolean undeliverableHere) {
            this.withOutcome(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere));
            return this;
        }

        public TransactionalStateBuilder modified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            this.withOutcome(new Modified().setDeliveryFailed(failed).setUndeliverableHere(undeliverableHere).setMessageAnnotations(TypeMapper.toSymbolKeyedMap(annotations)));
            return this;
        }
    }

    protected abstract class SectionBuilder {
        protected SectionBuilder() {
        }

        public TransferInjectAction also() {
            return TransferInjectAction.this;
        }

        public TransferInjectAction and() {
            return TransferInjectAction.this;
        }
    }
}

