/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;

class BinaryElement
extends AtomicElement<Binary> {
    private final Binary value;

    BinaryElement(Element<?> parent, Element<?> prev, Binary b) {
        super(parent, prev);
        byte[] data = new byte[b.getLength()];
        System.arraycopy(b.getArray(), 0, data, 0, b.getLength());
        this.value = new Binary(data);
    }

    @Override
    public int size() {
        int length = this.value.getLength();
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public Binary getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.BINARY;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            if (this.isElementOfArray()) {
                ArrayElement parent = (ArrayElement)this.parent();
                if (parent.constructorType() == ArrayElement.SMALL) {
                    output.writeByte((byte)this.value.getLength());
                } else {
                    output.writeInt(this.value.getLength());
                }
            } else if (this.value.getLength() <= 255) {
                output.writeByte(-96);
                output.writeByte((byte)this.value.getLength());
            } else {
                output.writeByte(-80);
                output.writeInt(this.value.getLength());
            }
            output.write(this.value.getArray(), 0, this.value.getLength());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

