/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class BooleanElement
extends AtomicElement<Boolean> {
    private final boolean value;

    public BooleanElement(Element<?> parent, Element<?> current, boolean b) {
        super(parent, current);
        this.value = b;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.BOOL;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            if (this.isElementOfArray()) {
                output.writeByte(this.value ? 1 : 0);
            } else {
                output.writeByte(this.value ? 65 : 66);
            }
            return 1;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

