/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class CharElement
extends AtomicElement<Integer> {
    private final int value;

    CharElement(Element<?> parent, Element<?> prev, int i) {
        super(parent, prev);
        this.value = i;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.CHAR;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 5) {
                output.writeByte(115);
            }
            output.writeInt(this.value);
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

