/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal64;

class Decimal64Element
extends AtomicElement<Decimal64> {
    private final Decimal64 value;

    Decimal64Element(Element<?> parent, Element<?> prev, Decimal64 d) {
        super(parent, prev);
        this.value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Decimal64 getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.DECIMAL64;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 9) {
                output.writeByte(-124);
            }
            output.writeLong(this.value.getBits());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

