/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class DoubleElement
extends AtomicElement<Double> {
    private final double value;

    DoubleElement(Element<?> parent, Element<?> prev, double d) {
        super(parent, prev);
        this.value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.DOUBLE;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 9) {
                output.writeByte(-126);
            }
            output.writeDouble(this.value);
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

