/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;

public abstract class ListDescribedType
implements DescribedType {
    private final ArrayList<Object> fields;

    public ListDescribedType(int numberOfFields) {
        this.fields = new ArrayList(numberOfFields);
        for (int i = 0; i < numberOfFields; ++i) {
            this.fields.add(null);
        }
    }

    public ListDescribedType(int numberOfFields, ListDescribedType described) {
        if (described.fields.size() > numberOfFields) {
            throw new IllegalArgumentException("List encoded exceeds expected number of elements for this type");
        }
        this.fields = new ArrayList(numberOfFields);
        for (int i = 0; i < numberOfFields; ++i) {
            if (i < described.fields.size()) {
                this.fields.add(described.fields.get(i));
                continue;
            }
            this.fields.add(null);
        }
    }

    public ListDescribedType(int numberOfFields, List<Object> described) {
        if (described.size() > numberOfFields) {
            throw new IllegalArgumentException("List encoded exceeds expected number of elements for this type");
        }
        this.fields = new ArrayList(numberOfFields);
        for (int i = 0; i < numberOfFields; ++i) {
            if (i < described.size()) {
                this.fields.add(described.get(i));
                continue;
            }
            this.fields.add(null);
        }
    }

    @Override
    public List<Object> getDescribed() {
        int highestSetField = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) == null) continue;
            highestSetField = i;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int j = 0; j <= highestSetField; ++j) {
            list.add(this.fields.get(j));
        }
        return list;
    }

    public Object getFieldValue(int index) {
        if (index < this.fields.size()) {
            return this.fields.get(index);
        }
        throw new AssertionError((Object)("Request for unknown field in type: " + String.valueOf(this)));
    }

    protected int getHighestSetFieldId() {
        int numUsedFields = 0;
        for (Object element : this.fields) {
            if (element == null) continue;
            ++numUsedFields;
        }
        return numUsedFields;
    }

    protected ArrayList<Object> getList() {
        return this.fields;
    }

    protected Object[] getFields() {
        return this.fields.toArray();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [descriptor=" + String.valueOf(this.getDescriptor()) + " fields=" + String.valueOf(this.getList()) + "]";
    }
}

