/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class StringElement
extends AtomicElement<String> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String value;

    StringElement(Element<?> parent, Element<?> prev, String s) {
        super(parent, prev);
        this.value = s;
    }

    @Override
    public int size() {
        int length = this.value.getBytes(UTF_8).length;
        return this.size(length);
    }

    private int size(int length) {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.STRING;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            byte[] bytes = this.value.getBytes(UTF_8);
            int length = bytes.length;
            int size = this.size(length);
            if (this.isElementOfArray()) {
                ArrayElement parent = (ArrayElement)this.parent();
                if (parent.constructorType() == ArrayElement.SMALL) {
                    output.writeByte((byte)length);
                } else {
                    output.writeInt(length);
                }
            } else if (length <= 255) {
                output.writeByte(-95);
                output.writeByte((byte)length);
            } else {
                output.writeByte(-79);
                output.writeInt(length);
            }
            output.write(bytes);
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

