/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal128;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal32;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal64;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;

class TypeDecoder {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final TypeConstructor[] constructors = new TypeConstructor[256];

    TypeDecoder() {
    }

    static int decode(ByteBuffer input, Codec data) {
        TypeConstructor c = TypeDecoder.readConstructor(input);
        int size = c.size(input);
        c.parse(input, data);
        return 1 + size;
    }

    private static TypeConstructor readConstructor(ByteBuffer input) {
        int index = input.get() & 0xFF;
        TypeConstructor tc = constructors[index];
        if (tc == null) {
            throw new IllegalArgumentException("No constructor for type " + index);
        }
        return tc;
    }

    private static void parseChildren(Codec data, ByteBuffer input, int count) {
        data.enter();
        for (int i = 0; i < count; ++i) {
            int getReadableBytes;
            TypeConstructor c = TypeDecoder.readConstructor(input);
            int size = c.size(input);
            if (size > (getReadableBytes = input.remaining())) {
                throw new IllegalArgumentException("Malformed data");
            }
            c.parse(input, data);
        }
        data.exit();
    }

    private static void parseArray(Codec data, ByteBuffer input, int count) {
        byte type = input.get();
        boolean isDescribed = type == 0;
        int descriptorPosition = input.position();
        if (isDescribed) {
            TypeConstructor descriptorTc = TypeDecoder.readConstructor(input);
            input.position(input.position() + descriptorTc.size(input));
            type = input.get();
            if (type == 0) {
                throw new IllegalArgumentException("Malformed array data");
            }
        }
        TypeConstructor tc = constructors[type & 0xFF];
        data.putArray(isDescribed, tc.getType());
        data.enter();
        if (isDescribed) {
            int position = input.position();
            input.position(descriptorPosition);
            TypeConstructor descriptorTc = TypeDecoder.readConstructor(input);
            descriptorTc.parse(input, data);
            input.position(position);
        }
        for (int i = 0; i < count; ++i) {
            tc.parse(input, data);
        }
        data.exit();
    }

    static {
        TypeDecoder.constructors[0] = new DescribedTypeConstructor();
        TypeDecoder.constructors[64] = new NullConstructor();
        TypeDecoder.constructors[65] = new TrueConstructor();
        TypeDecoder.constructors[66] = new FalseConstructor();
        TypeDecoder.constructors[67] = new UInt0Constructor();
        TypeDecoder.constructors[68] = new ULong0Constructor();
        TypeDecoder.constructors[69] = new EmptyListConstructor();
        TypeDecoder.constructors[80] = new UByteConstructor();
        TypeDecoder.constructors[81] = new ByteConstructor();
        TypeDecoder.constructors[82] = new SmallUIntConstructor();
        TypeDecoder.constructors[83] = new SmallULongConstructor();
        TypeDecoder.constructors[84] = new SmallIntConstructor();
        TypeDecoder.constructors[85] = new SmallLongConstructor();
        TypeDecoder.constructors[86] = new BooleanConstructor();
        TypeDecoder.constructors[96] = new UShortConstructor();
        TypeDecoder.constructors[97] = new ShortConstructor();
        TypeDecoder.constructors[112] = new UIntConstructor();
        TypeDecoder.constructors[113] = new IntConstructor();
        TypeDecoder.constructors[114] = new FloatConstructor();
        TypeDecoder.constructors[115] = new CharConstructor();
        TypeDecoder.constructors[116] = new Decimal32Constructor();
        TypeDecoder.constructors[128] = new ULongConstructor();
        TypeDecoder.constructors[129] = new LongConstructor();
        TypeDecoder.constructors[130] = new DoubleConstructor();
        TypeDecoder.constructors[131] = new TimestampConstructor();
        TypeDecoder.constructors[132] = new Decimal64Constructor();
        TypeDecoder.constructors[148] = new Decimal128Constructor();
        TypeDecoder.constructors[152] = new UUIDConstructor();
        TypeDecoder.constructors[160] = new SmallBinaryConstructor();
        TypeDecoder.constructors[161] = new SmallStringConstructor();
        TypeDecoder.constructors[163] = new SmallSymbolConstructor();
        TypeDecoder.constructors[176] = new BinaryConstructor();
        TypeDecoder.constructors[177] = new StringConstructor();
        TypeDecoder.constructors[179] = new SymbolConstructor();
        TypeDecoder.constructors[192] = new SmallListConstructor();
        TypeDecoder.constructors[193] = new SmallMapConstructor();
        TypeDecoder.constructors[208] = new ListConstructor();
        TypeDecoder.constructors[209] = new MapConstructor();
        TypeDecoder.constructors[224] = new SmallArrayConstructor();
        TypeDecoder.constructors[240] = new ArrayConstructor();
    }

    private static interface TypeConstructor {
        public Codec.DataType getType();

        public int size(ByteBuffer var1);

        public void parse(ByteBuffer var1, Codec var2);
    }

    private static class DescribedTypeConstructor
    implements TypeConstructor {
        private DescribedTypeConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.DESCRIBED;
        }

        @Override
        public int size(ByteBuffer input) {
            ByteBuffer buf = input.slice().asReadOnlyBuffer();
            TypeConstructor c = TypeDecoder.readConstructor(buf);
            int size = c.size(buf);
            buf.position(size + 1);
            c = TypeDecoder.readConstructor(buf);
            return size + 2 + c.size(buf);
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putDescribed();
            data.enter();
            TypeConstructor c = TypeDecoder.readConstructor(input);
            c.parse(input, data);
            c = TypeDecoder.readConstructor(input);
            c.parse(input, data);
            data.exit();
        }
    }

    private static class NullConstructor
    implements TypeConstructor {
        private NullConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.NULL;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putNull();
        }
    }

    private static class TrueConstructor
    implements TypeConstructor {
        private TrueConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BOOL;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putBoolean(true);
        }
    }

    private static class FalseConstructor
    implements TypeConstructor {
        private FalseConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BOOL;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putBoolean(false);
        }
    }

    private static class UInt0Constructor
    implements TypeConstructor {
        private UInt0Constructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.UINT;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedInteger(UnsignedInteger.ZERO);
        }
    }

    private static class ULong0Constructor
    implements TypeConstructor {
        private ULong0Constructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.ULONG;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedLong(UnsignedLong.ZERO);
        }
    }

    private static class EmptyListConstructor
    implements TypeConstructor {
        private EmptyListConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.LIST;
        }

        @Override
        public int size(ByteBuffer input) {
            return 0;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putList();
        }
    }

    private static class UByteConstructor
    extends Fixed1SizeConstructor {
        private UByteConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.UBYTE;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedByte(UnsignedByte.valueOf(input.get()));
        }
    }

    private static class ByteConstructor
    extends Fixed1SizeConstructor {
        private ByteConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BYTE;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putByte(input.get());
        }
    }

    private static class SmallUIntConstructor
    extends Fixed1SizeConstructor {
        private SmallUIntConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.UINT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedInteger(UnsignedInteger.valueOf(input.get() & 0xFF));
        }
    }

    private static class SmallULongConstructor
    extends Fixed1SizeConstructor {
        private SmallULongConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.ULONG;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedLong(UnsignedLong.valueOf(input.get() & 0xFF));
        }
    }

    private static class SmallIntConstructor
    extends Fixed1SizeConstructor {
        private SmallIntConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.INT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putInt(input.get());
        }
    }

    private static class SmallLongConstructor
    extends Fixed1SizeConstructor {
        private SmallLongConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.LONG;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putLong(input.get());
        }
    }

    private static class BooleanConstructor
    extends Fixed1SizeConstructor {
        private BooleanConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BOOL;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            byte i = input.get();
            if (i != 0 && i != 1) {
                throw new IllegalArgumentException("Illegal value " + i + " for boolean");
            }
            data.putBoolean(i == 1);
        }
    }

    private static class UShortConstructor
    extends Fixed2SizeConstructor {
        private UShortConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.USHORT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedShort(UnsignedShort.valueOf(input.getShort()));
        }
    }

    private static class ShortConstructor
    extends Fixed2SizeConstructor {
        private ShortConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.SHORT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putShort(input.getShort());
        }
    }

    private static class UIntConstructor
    extends Fixed4SizeConstructor {
        private UIntConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.UINT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedInteger(UnsignedInteger.valueOf(input.getInt()));
        }
    }

    private static class IntConstructor
    extends Fixed4SizeConstructor {
        private IntConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.INT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putInt(input.getInt());
        }
    }

    private static class FloatConstructor
    extends Fixed4SizeConstructor {
        private FloatConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.FLOAT;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putFloat(input.getFloat());
        }
    }

    private static class CharConstructor
    extends Fixed4SizeConstructor {
        private CharConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.CHAR;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putChar(input.getInt());
        }
    }

    private static class Decimal32Constructor
    extends Fixed4SizeConstructor {
        private Decimal32Constructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.DECIMAL32;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putDecimal32(new Decimal32(input.getInt()));
        }
    }

    private static class ULongConstructor
    extends Fixed8SizeConstructor {
        private ULongConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.ULONG;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUnsignedLong(UnsignedLong.valueOf(input.getLong()));
        }
    }

    private static class LongConstructor
    extends Fixed8SizeConstructor {
        private LongConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.LONG;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putLong(input.getLong());
        }
    }

    private static class DoubleConstructor
    extends Fixed8SizeConstructor {
        private DoubleConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.DOUBLE;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putDouble(input.getDouble());
        }
    }

    private static class TimestampConstructor
    extends Fixed8SizeConstructor {
        private TimestampConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.TIMESTAMP;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putTimestamp(new Date(input.getLong()));
        }
    }

    private static class Decimal64Constructor
    extends Fixed8SizeConstructor {
        private Decimal64Constructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.DECIMAL64;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putDecimal64(new Decimal64(input.getLong()));
        }
    }

    private static class Decimal128Constructor
    extends Fixed16SizeConstructor {
        private Decimal128Constructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.DECIMAL128;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putDecimal128(new Decimal128(input.getLong(), input.getLong()));
        }
    }

    private static class UUIDConstructor
    extends Fixed16SizeConstructor {
        private UUIDConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.UUID;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            data.putUUID(new UUID(input.getLong(), input.getLong()));
        }
    }

    private static class SmallBinaryConstructor
    extends SmallVariableConstructor {
        private SmallBinaryConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BINARY;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putBinary(bytes);
        }
    }

    private static class SmallStringConstructor
    extends SmallVariableConstructor {
        private SmallStringConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.STRING;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putString(new String(bytes, UTF_8));
        }
    }

    private static class SmallSymbolConstructor
    extends SmallVariableConstructor {
        private SmallSymbolConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.SYMBOL;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putSymbol(Symbol.valueOf(new String(bytes, ASCII)));
        }
    }

    private static class BinaryConstructor
    extends VariableConstructor {
        private BinaryConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.BINARY;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putBinary(bytes);
        }
    }

    private static class StringConstructor
    extends VariableConstructor {
        private StringConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.STRING;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putString(new String(bytes, UTF_8));
        }
    }

    private static class SymbolConstructor
    extends VariableConstructor {
        private SymbolConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.SYMBOL;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            byte[] bytes = new byte[size];
            input.get(bytes, 0, bytes.length);
            data.putSymbol(Symbol.valueOf(new String(bytes, ASCII)));
        }
    }

    private static class SmallListConstructor
    extends SmallVariableConstructor {
        private SmallListConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.LIST;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            ByteBuffer duplicate = input.slice().asReadOnlyBuffer();
            int count = duplicate.get() & 0xFF;
            input.position(input.position() + size);
            data.putList();
            TypeDecoder.parseChildren(data, duplicate, count);
        }
    }

    private static class SmallMapConstructor
    extends SmallVariableConstructor {
        private SmallMapConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.MAP;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            ByteBuffer duplicate = input.slice().asReadOnlyBuffer();
            int count = duplicate.get() & 0xFF;
            input.position(input.position() + size);
            data.putMap();
            TypeDecoder.parseChildren(data, duplicate, count);
        }
    }

    private static class ListConstructor
    extends VariableConstructor {
        private ListConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.LIST;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            ByteBuffer duplicate = input.slice().asReadOnlyBuffer();
            int count = duplicate.getInt();
            input.position(input.position() + size);
            data.putList();
            TypeDecoder.parseChildren(data, duplicate, count);
        }
    }

    private static class MapConstructor
    extends VariableConstructor {
        private MapConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.MAP;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            ByteBuffer duplicate = input.slice().asReadOnlyBuffer();
            int count = duplicate.getInt();
            input.position(input.position() + size);
            data.putMap();
            TypeDecoder.parseChildren(data, duplicate, count);
        }
    }

    private static class SmallArrayConstructor
    extends SmallVariableConstructor {
        private SmallArrayConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.ARRAY;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.get() & 0xFF;
            ByteBuffer buf = input.slice().asReadOnlyBuffer();
            input.position(input.position() + size);
            int count = buf.get() & 0xFF;
            TypeDecoder.parseArray(data, buf, count);
        }
    }

    private static class ArrayConstructor
    extends VariableConstructor {
        private ArrayConstructor() {
        }

        @Override
        public Codec.DataType getType() {
            return Codec.DataType.ARRAY;
        }

        @Override
        public void parse(ByteBuffer input, Codec data) {
            int size = input.getInt();
            ByteBuffer buf = input.slice().asReadOnlyBuffer();
            input.position(input.position() + size);
            int count = buf.getInt();
            TypeDecoder.parseArray(data, buf, count);
        }
    }

    private static abstract class VariableConstructor
    implements TypeConstructor {
        private VariableConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            int position = input.position();
            if (input.remaining() >= 4) {
                int size = input.getInt();
                input.position(position);
                return size + 4;
            }
            return 4;
        }
    }

    private static abstract class SmallVariableConstructor
    implements TypeConstructor {
        private SmallVariableConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            int position = input.position();
            if (input.remaining() > 0) {
                int size = input.get() & 0xFF;
                input.position(position);
                return size + 1;
            }
            return 1;
        }
    }

    private static abstract class Fixed16SizeConstructor
    implements TypeConstructor {
        private Fixed16SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            return 16;
        }
    }

    private static abstract class Fixed8SizeConstructor
    implements TypeConstructor {
        private Fixed8SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            return 8;
        }
    }

    private static abstract class Fixed4SizeConstructor
    implements TypeConstructor {
        private Fixed4SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            return 4;
        }
    }

    private static abstract class Fixed2SizeConstructor
    implements TypeConstructor {
        private Fixed2SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            return 2;
        }
    }

    private static abstract class Fixed1SizeConstructor
    implements TypeConstructor {
        private Fixed1SizeConstructor() {
        }

        @Override
        public int size(ByteBuffer input) {
            return 1;
        }
    }

    private static abstract class Fixed0SizeConstructor
    implements TypeConstructor {
        private Fixed0SizeConstructor() {
        }

        @Override
        public final int size(ByteBuffer input) {
            return 0;
        }
    }
}

