/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;

class UnsignedLongElement
extends AtomicElement<UnsignedLong> {
    private final UnsignedLong value;

    UnsignedLongElement(Element<?> parent, Element<?> prev, UnsignedLong ul) {
        super(parent, prev);
        this.value = ul;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (this.value.longValue() == 0L) {
                    return 0;
                }
                parent.setConstructorType(ArrayElement.SMALL);
            }
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (0L <= this.value.longValue() && this.value.longValue() <= 255L) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 8;
        }
        return 0L == this.value.longValue() ? 1 : (1L <= this.value.longValue() && this.value.longValue() <= 255L ? 2 : 9);
    }

    @Override
    public UnsignedLong getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.ULONG;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            switch (size) {
                case 1: {
                    if (this.isElementOfArray()) {
                        output.writeByte((byte)this.value.longValue());
                        break;
                    }
                    output.writeByte(68);
                    break;
                }
                case 2: {
                    output.writeByte(83);
                    output.writeByte((byte)this.value.longValue());
                    break;
                }
                case 9: {
                    output.writeByte(-128);
                }
                case 8: {
                    output.writeLong(this.value.longValue());
                }
            }
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

