/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.primitives;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Binary {
    private final byte[] buffer;
    private int hashCode;

    public Binary() {
        this.buffer = null;
    }

    public Binary(byte[] data) {
        this(data, 0, data != null ? data.length : 0);
    }

    public Binary(byte[] data, int offset, int length) {
        this.buffer = data != null ? Arrays.copyOfRange(data, offset, offset + length) : null;
    }

    public Binary copy() {
        if (this.buffer == null) {
            return new Binary();
        }
        return new Binary(Arrays.copyOf(this.buffer, this.buffer.length));
    }

    public byte[] arrayCopy() {
        byte[] dataCopy = null;
        if (this.buffer != null) {
            dataCopy = Arrays.copyOf(this.buffer, this.buffer.length);
        }
        return dataCopy;
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer != null ? ByteBuffer.wrap(this.buffer) : null;
    }

    public final int hashCode() {
        int hc = this.hashCode;
        if (hc == 0 && this.buffer != null) {
            this.hashCode = Arrays.hashCode(this.buffer);
        }
        return hc;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary other = (Binary)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.buffer == null) {
            return other.buffer == null;
        }
        return Arrays.equals(this.buffer, other.buffer);
    }

    public boolean hasArray() {
        return this.buffer != null;
    }

    public byte[] getArray() {
        return this.buffer;
    }

    public int getLength() {
        return this.buffer != null ? this.buffer.length : 0;
    }

    public String toString() {
        if (this.buffer == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            byte c = this.buffer[i];
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        return str.toString();
    }
}

