/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.primitives;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Symbol
implements Comparable<Symbol> {
    private static final Map<ByteBuffer, Symbol> bufferToSymbols = new ConcurrentHashMap<ByteBuffer, Symbol>(2048);
    private static final Map<String, Symbol> stringToSymbols = new ConcurrentHashMap<String, Symbol>(2048);
    private static final Symbol EMPTY_SYMBOL = new Symbol();
    private static final int MAX_CACHED_SYMBOL_SIZE = 64;
    private String symbolString;
    private final ByteBuffer underlying;
    private final int hashCode;

    private Symbol() {
        this.underlying = ByteBuffer.allocate(0);
        this.hashCode = 31;
        this.symbolString = "";
    }

    private Symbol(ByteBuffer underlying) {
        this.underlying = underlying;
        this.hashCode = underlying.hashCode();
    }

    public int getLength() {
        return this.underlying.remaining();
    }

    @Override
    public int compareTo(Symbol other) {
        return this.underlying.compareTo(other.underlying);
    }

    public String toString() {
        if (this.symbolString == null && this.underlying.remaining() > 0) {
            Symbol existing;
            this.symbolString = new String(this.underlying.array(), this.underlying.arrayOffset(), this.underlying.remaining(), StandardCharsets.US_ASCII);
            if (this.underlying.remaining() <= 64 && (existing = stringToSymbols.putIfAbsent(this.symbolString, this)) != null) {
                this.symbolString = existing.symbolString;
            }
        }
        return this.symbolString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Symbol) {
            return this.underlying.equals(((Symbol)other).underlying);
        }
        return false;
    }

    public void writeTo(ByteBuffer target) {
        for (int i = 0; i < this.underlying.remaining(); ++i) {
            target.put(this.underlying.get(i));
        }
    }

    public static Symbol valueOf(String symbolVal) {
        return Symbol.getSymbol(symbolVal);
    }

    public static Symbol getSymbol(ByteBuffer symbolBytes) {
        return Symbol.getSymbol(symbolBytes, false);
    }

    public static Symbol getSymbol(ByteBuffer symbolBuffer, boolean copyOnCreate) {
        if (symbolBuffer == null) {
            return null;
        }
        if (!symbolBuffer.hasRemaining()) {
            return EMPTY_SYMBOL;
        }
        Symbol symbol = bufferToSymbols.get(symbolBuffer);
        if (symbol == null) {
            Symbol existing;
            if (copyOnCreate) {
                int symbolSize = symbolBuffer.remaining();
                byte[] copy = new byte[symbolSize];
                symbolBuffer.get(copy, 0, symbolSize);
                symbolBuffer.position(symbolBuffer.position() - symbolSize);
                symbolBuffer = ByteBuffer.wrap(copy);
            }
            symbol = new Symbol(symbolBuffer);
            if (symbolBuffer.remaining() <= 64 && (existing = bufferToSymbols.putIfAbsent(symbolBuffer, symbol)) != null) {
                symbol = existing;
            }
        }
        return symbol;
    }

    public static Symbol getSymbol(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (stringValue.isEmpty()) {
            return EMPTY_SYMBOL;
        }
        Symbol symbol = stringToSymbols.get(stringValue);
        if (symbol == null) {
            symbol = Symbol.getSymbol(ByteBuffer.wrap(stringValue.getBytes(StandardCharsets.US_ASCII)));
            if (symbol.underlying.remaining() <= 64) {
                stringToSymbols.put(stringValue, symbol);
            }
        }
        return symbol;
    }
}

