/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.security;

import java.util.List;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;

public class SaslInit
extends SaslDescribedType {
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:sasl-init:list");
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(65L);

    public SaslInit() {
        super(Field.values().length);
    }

    public SaslInit(Object described) {
        super(Field.values().length, (List)described);
    }

    public SaslInit(List<Object> described) {
        super(Field.values().length, described);
    }

    @Override
    public Symbol getDescriptor() {
        return DESCRIPTOR_SYMBOL;
    }

    public SaslInit setMechanism(Symbol o) {
        this.getList().set(Field.MECHANISM.ordinal(), o);
        return this;
    }

    public Symbol getMechanism() {
        return (Symbol)this.getList().get(Field.MECHANISM.ordinal());
    }

    public SaslInit setInitialResponse(Binary o) {
        this.getList().set(Field.INITIAL_RESPONSE.ordinal(), o);
        return this;
    }

    public Binary getInitialResponse() {
        return (Binary)this.getList().get(Field.INITIAL_RESPONSE.ordinal());
    }

    public SaslInit setHostname(String o) {
        this.getList().set(Field.HOSTNAME.ordinal(), o);
        return this;
    }

    public String getHostname() {
        return (String)this.getList().get(Field.HOSTNAME.ordinal());
    }

    @Override
    public SaslDescribedType.SaslPerformativeType getPerformativeType() {
        return SaslDescribedType.SaslPerformativeType.INIT;
    }

    @Override
    public <E> void invoke(SaslDescribedType.SaslPerformativeHandler<E> handler, int frameSize, E context) {
        handler.handleInit(frameSize, this, context);
    }

    @Override
    public String toString() {
        return "SaslInit{mechanism=" + String.valueOf(this.getMechanism()) + ", initialResponse=" + TypeMapper.toQuotedString(this.getInitialResponse()) + ", hostname='" + this.getHostname() + "'}";
    }

    public static enum Field {
        MECHANISM,
        INITIAL_RESPONSE,
        HOSTNAME;

    }
}

