/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.transport;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.PerformativeDescribedType;

public class Open
extends PerformativeDescribedType {
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:open:list");
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(16L);

    public Open() {
        super(Field.values().length);
    }

    public Open(Object described) {
        super(Field.values().length, (List)described);
    }

    public Open(List<Object> described) {
        super(Field.values().length, described);
    }

    @Override
    public Symbol getDescriptor() {
        return DESCRIPTOR_SYMBOL;
    }

    public Open setContainerId(String o) {
        this.getList().set(Field.CONTAINER_ID.ordinal(), o);
        return this;
    }

    public String getContainerId() {
        return (String)this.getList().get(Field.CONTAINER_ID.ordinal());
    }

    public Open setHostname(String o) {
        this.getList().set(Field.HOSTNAME.ordinal(), o);
        return this;
    }

    public String getHostname() {
        return (String)this.getList().get(Field.HOSTNAME.ordinal());
    }

    public Open setMaxFrameSize(UnsignedInteger o) {
        this.getList().set(Field.MAX_FRAME_SIZE.ordinal(), o);
        return this;
    }

    public UnsignedInteger getMaxFrameSize() {
        return (UnsignedInteger)this.getList().get(Field.MAX_FRAME_SIZE.ordinal());
    }

    public Open setChannelMax(UnsignedShort o) {
        this.getList().set(Field.CHANNEL_MAX.ordinal(), o);
        return this;
    }

    public UnsignedShort getChannelMax() {
        return (UnsignedShort)this.getList().get(Field.CHANNEL_MAX.ordinal());
    }

    public Open setIdleTimeOut(UnsignedInteger o) {
        this.getList().set(Field.IDLE_TIME_OUT.ordinal(), o);
        return this;
    }

    public UnsignedInteger getIdleTimeOut() {
        return (UnsignedInteger)this.getList().get(Field.IDLE_TIME_OUT.ordinal());
    }

    public Open setOutgoingLocales(Symbol[] o) {
        this.getList().set(Field.OUTGOING_LOCALES.ordinal(), o);
        return this;
    }

    public Symbol[] getOutgoingLocales() {
        return (Symbol[])this.getList().get(Field.OUTGOING_LOCALES.ordinal());
    }

    public Open setIncomingLocales(Symbol[] o) {
        this.getList().set(Field.INCOMING_LOCALES.ordinal(), o);
        return this;
    }

    public Symbol[] getIncomingLocales() {
        return (Symbol[])this.getList().get(Field.INCOMING_LOCALES.ordinal());
    }

    public Open setOfferedCapabilities(Symbol[] o) {
        this.getList().set(Field.OFFERED_CAPABILITIES.ordinal(), o);
        return this;
    }

    public Symbol[] getOfferedCapabilities() {
        return (Symbol[])this.getList().get(Field.OFFERED_CAPABILITIES.ordinal());
    }

    public Open setDesiredCapabilities(Symbol[] o) {
        this.getList().set(Field.DESIRED_CAPABILITIES.ordinal(), o);
        return this;
    }

    public Symbol[] getDesiredCapabilities() {
        return (Symbol[])this.getList().get(Field.DESIRED_CAPABILITIES.ordinal());
    }

    public Open setProperties(Map<Symbol, Object> o) {
        this.getList().set(Field.PROPERTIES.ordinal(), o);
        return this;
    }

    public Map<Symbol, Object> getProperties() {
        return (Map)this.getList().get(Field.PROPERTIES.ordinal());
    }

    @Override
    public PerformativeDescribedType.PerformativeType getPerformativeType() {
        return PerformativeDescribedType.PerformativeType.OPEN;
    }

    @Override
    public <E> void invoke(PerformativeDescribedType.PerformativeHandler<E> handler, int frameSize, ByteBuffer payload, int channel, E context) {
        handler.handleOpen(frameSize, this, payload, channel, context);
    }

    @Override
    public Object getFieldValueOrSpecDefault(int index) {
        Object result = this.getFieldValue(index);
        if (result == null) {
            Field field = Field.values()[index];
            switch (field.ordinal()) {
                case 2: {
                    result = UnsignedInteger.MAX_VALUE;
                    break;
                }
                case 3: {
                    result = UnsignedShort.MAX_VALUE;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "Open{ containerId='" + this.getContainerId() + "', hostname='" + this.getHostname() + "', maxFrameSize=" + String.valueOf(this.getMaxFrameSize()) + ", channelMax=" + String.valueOf(this.getChannelMax()) + ", idleTimeOut=" + String.valueOf(this.getIdleTimeOut()) + ", outgoingLocales=" + Arrays.toString(this.getOutgoingLocales()) + ", incomingLocales=" + Arrays.toString(this.getIncomingLocales()) + ", offeredCapabilities=" + Arrays.toString(this.getOfferedCapabilities()) + ", desiredCapabilities=" + Arrays.toString(this.getDesiredCapabilities()) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    public static enum Field {
        CONTAINER_ID,
        HOSTNAME,
        MAX_FRAME_SIZE,
        CHANNEL_MAX,
        IDLE_TIME_OUT,
        OUTGOING_LOCALES,
        INCOMING_LOCALES,
        OFFERED_CAPABILITIES,
        DESIRED_CAPABILITIES,
        PROPERTIES;

    }
}

