/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.transport;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Begin;
import org.apache.qpid.protonj2.test.driver.codec.transport.Close;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Disposition;
import org.apache.qpid.protonj2.test.driver.codec.transport.End;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;
import org.apache.qpid.protonj2.test.driver.codec.transport.HeartBeat;
import org.apache.qpid.protonj2.test.driver.codec.transport.Open;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;

public abstract class PerformativeDescribedType
extends ListDescribedType {
    public PerformativeDescribedType(int numberOfFields) {
        super(numberOfFields);
    }

    public PerformativeDescribedType(int numberOfFields, List<Object> described) {
        super(numberOfFields, described);
    }

    public abstract PerformativeType getPerformativeType();

    public Object getFieldValueOrSpecDefault(int index) {
        return this.getFieldValue(index);
    }

    public abstract <E> void invoke(PerformativeHandler<E> var1, int var2, ByteBuffer var3, int var4, E var5);

    @Override
    public String toString() {
        return String.valueOf((Object)this.getPerformativeType()) + " " + String.valueOf(this.getList());
    }

    public static enum PerformativeType {
        ATTACH,
        BEGIN,
        CLOSE,
        DETACH,
        DISPOSITION,
        END,
        FLOW,
        OPEN,
        TRANSFER,
        HEARTBEAT;

    }

    public static interface PerformativeHandler<E> {
        default public void handleOpen(int frameSize, Open open, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Open was not handled");
        }

        default public void handleBegin(int frameSize, Begin begin, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Begin was not handled");
        }

        default public void handleAttach(int frameSize, Attach attach, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Attach was not handled");
        }

        default public void handleFlow(int frameSize, Flow flow, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Flow was not handled");
        }

        default public void handleTransfer(int frameSize, Transfer transfer, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Transfer was not handled");
        }

        default public void handleDisposition(int frameSize, Disposition disposition, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Disposition was not handled");
        }

        default public void handleDetach(int frameSize, Detach detach, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Detach was not handled");
        }

        default public void handleEnd(int frameSize, End end, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP End was not handled");
        }

        default public void handleClose(int frameSize, Close close, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Close was not handled");
        }

        default public void handleHeartBeat(int frameSize, HeartBeat thump, ByteBuffer payload, int channel, E context) {
            throw new AssertionError((Object)"AMQP Heart Beat frame was not handled");
        }
    }
}

