/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;

public abstract class TypeMapper {
    private static final int DEFAULT_QUOTED_STRING_LIMIT = 64;

    private TypeMapper() {
    }

    public static Symbol[] toSymbolArray(String[] stringArray) {
        Symbol[] result = null;
        if (stringArray != null) {
            result = new Symbol[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                result[i] = Symbol.valueOf(stringArray[i]);
            }
        }
        return result;
    }

    public static Map<Symbol, Object> toSymbolKeyedMap(Map<String, Object> stringsMap) {
        HashMap result;
        if (stringsMap != null) {
            result = new HashMap(stringsMap.size());
            stringsMap.forEach((key, value) -> result.put(Symbol.valueOf(key), value));
        } else {
            result = null;
        }
        return result;
    }

    public static String toQuotedString(Binary buffer) {
        return TypeMapper.toQuotedString(buffer, 64, true);
    }

    public static String toQuotedString(Binary buffer, boolean appendIfTruncated) {
        return TypeMapper.toQuotedString(buffer, 64, appendIfTruncated);
    }

    public static String toQuotedString(Binary buffer, int stringLength, boolean appendIfTruncated) {
        if (buffer == null || buffer.getArray() == null) {
            return "\"\"";
        }
        StringBuilder str = new StringBuilder();
        str.append("\"");
        int byteToRead = buffer.getLength();
        int size = 0;
        boolean truncated = false;
        for (int i = 0; i < byteToRead; ++i) {
            byte c = buffer.getArray()[i];
            if (c > 31 && c < 127 && c != 92) {
                if (size + 1 <= stringLength) {
                    ++size;
                    str.append((char)c);
                    continue;
                }
                truncated = true;
                break;
            }
            if (size + 4 <= stringLength) {
                size += 4;
                str.append(String.format("\\x%02x", c));
                continue;
            }
            truncated = true;
            break;
        }
        str.append("\"");
        if (truncated && appendIfTruncated) {
            str.append("...(truncated)");
        }
        return str.toString();
    }
}

