/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.actions.DispositionInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Declare;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Declared;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.expectations.TransferExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DeclareExpectation
extends TransferExpectation {
    private final EncodedAmqpValueMatcher defaultPayloadMatcher = new EncodedAmqpValueMatcher(new Declare());

    public DeclareExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withPayload((Matcher<ByteBuffer>)this.defaultPayloadMatcher);
    }

    @Override
    public DispositionInjectAction accept() {
        byte[] txnId = new byte[4];
        Random rand = new Random();
        rand.setSeed(System.nanoTime());
        rand.nextBytes(txnId);
        return this.accept(txnId);
    }

    public DispositionInjectAction accept(byte[] txnId) {
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        if (txnId != null) {
            this.response.withState(new Declared().setTxnId(new Binary(txnId)));
        } else {
            this.response.withState(new Declared());
        }
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DispositionInjectAction declared(byte[] txnId) {
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        if (txnId != null) {
            this.response.withState(new Declared().setTxnId(new Binary(txnId)));
        } else {
            this.response.withState(new Declared());
        }
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    @Override
    public DeclareExpectation optional() {
        return (DeclareExpectation)super.optional();
    }

    @Override
    public DeclareExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public DeclareExpectation withDeclare(Declare declare) {
        this.withPayload((Matcher<ByteBuffer>)new EncodedAmqpValueMatcher(declare));
        return this;
    }

    public DeclareExpectation withNullDeclare() {
        this.withPayload((Matcher<ByteBuffer>)new EncodedAmqpValueMatcher(null));
        return this;
    }

    @Override
    public DeclareExpectation withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    @Override
    public DeclareExpectation withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    @Override
    public DeclareExpectation withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    @Override
    public DeclareExpectation withDeliveryId(int deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    @Override
    public DeclareExpectation withDeliveryId(long deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    @Override
    public DeclareExpectation withDeliveryId(UnsignedInteger deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)deliveryId));
    }

    @Override
    public DeclareExpectation withDeliveryTag(byte[] tag) {
        return this.withDeliveryTag(new Binary(tag));
    }

    @Override
    public DeclareExpectation withDeliveryTag(Binary deliveryTag) {
        return this.withDeliveryTag(CoreMatchers.equalTo((Object)deliveryTag));
    }

    @Override
    public DeclareExpectation withMessageFormat(int messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    @Override
    public DeclareExpectation withMessageFormat(long messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    @Override
    public DeclareExpectation withMessageFormat(UnsignedInteger messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)messageFormat));
    }

    @Override
    public DeclareExpectation withSettled(boolean settled) {
        return this.withSettled(CoreMatchers.equalTo((Object)settled));
    }

    @Override
    public DeclareExpectation withMore(boolean more) {
        return this.withMore(CoreMatchers.equalTo((Object)more));
    }

    @Override
    public DeclareExpectation withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)rcvSettleMode.getValue()));
    }

    @Override
    public DeclareExpectation withState(DeliveryState state) {
        return this.withState(CoreMatchers.equalTo((Object)state));
    }

    @Override
    public DeclareExpectation withNullState() {
        return this.withState(CoreMatchers.nullValue());
    }

    @Override
    public DeclareExpectation withResume(boolean resume) {
        return this.withResume(CoreMatchers.equalTo((Object)resume));
    }

    @Override
    public DeclareExpectation withAborted(boolean aborted) {
        return this.withAborted(CoreMatchers.equalTo((Object)aborted));
    }

    @Override
    public DeclareExpectation withBatchable(boolean batchable) {
        return this.withBatchable(CoreMatchers.equalTo((Object)batchable));
    }

    @Override
    public DeclareExpectation withHandle(Matcher<?> m) {
        super.withHandle(m);
        return this;
    }

    @Override
    public DeclareExpectation withDeliveryId(Matcher<?> m) {
        super.withDeliveryId(m);
        return this;
    }

    @Override
    public DeclareExpectation withDeliveryTag(Matcher<?> m) {
        super.withDeliveryTag(m);
        return this;
    }

    @Override
    public DeclareExpectation withMessageFormat(Matcher<?> m) {
        super.withMessageFormat(m);
        return this;
    }

    @Override
    public DeclareExpectation withSettled(Matcher<?> m) {
        super.withSettled(m);
        return this;
    }

    @Override
    public DeclareExpectation withMore(Matcher<?> m) {
        super.withMore(m);
        return this;
    }

    @Override
    public DeclareExpectation withRcvSettleMode(Matcher<?> m) {
        super.withRcvSettleMode(m);
        return this;
    }

    @Override
    public DeclareExpectation withState(Matcher<?> m) {
        super.withState(m);
        return this;
    }

    @Override
    public DeclareExpectation withResume(Matcher<?> m) {
        super.withResume(m);
        return this;
    }

    @Override
    public DeclareExpectation withAborted(Matcher<?> m) {
        super.withAborted(m);
        return this;
    }

    @Override
    public DeclareExpectation withBatchable(Matcher<?> m) {
        super.withBatchable(m);
        return this;
    }
}

