/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.actions.CloseInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.OpenInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Open;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.transport.OpenMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.ArrayMatching;

public class OpenExpectation
extends AbstractExpectation<Open> {
    private final OpenMatcher matcher = new OpenMatcher();
    private OpenInjectAction response;
    private boolean explicitlyNullContainerId;
    private boolean inKindResponse;

    public OpenExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withContainerId(CoreMatchers.notNullValue());
        this.onChannel(0);
    }

    public OpenExpectation optional() {
        return (OpenExpectation)super.optional();
    }

    public OpenExpectation withPredicate(Predicate<Open> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public OpenExpectation withCapture(Consumer<Open> capture) {
        super.withCapture(capture);
        return this;
    }

    public OpenInjectAction respond() {
        this.response = new OpenInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public OpenInjectAction respondInKind() {
        this.response = new OpenInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        this.inKindResponse = true;
        return this.response;
    }

    public CloseInjectAction reject() {
        this.response = new OpenInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        CloseInjectAction closeAction = new CloseInjectAction(this.driver);
        this.driver.addScriptedElement(closeAction);
        return closeAction;
    }

    public CloseInjectAction reject(String condition, String description) {
        return this.reject(Symbol.valueOf(condition), description);
    }

    public CloseInjectAction reject(String condition, String description, Map<String, Object> infoMap) {
        return this.reject(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(infoMap));
    }

    public CloseInjectAction reject(Symbol condition, String description) {
        return this.reject(condition, description, null);
    }

    public CloseInjectAction reject(Symbol condition, String description, Map<Symbol, Object> infoMap) {
        this.response = new OpenInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        CloseInjectAction closeAction = new CloseInjectAction(this.driver).withErrorCondition(condition, description, infoMap);
        this.driver.addScriptedElement(closeAction);
        return closeAction;
    }

    @Override
    public void handleOpen(int frameSize, Open open, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleOpen(frameSize, open, payload, channel, context);
        if (this.response != null) {
            if (this.response.getPerformative().getContainerId() == null && !this.explicitlyNullContainerId) {
                this.response.getPerformative().setContainerId("driver");
            }
            if (this.response.onChannel() == -1) {
                this.response.onChannel(channel);
            }
            if (this.inKindResponse) {
                Symbol[] desired = open.getDesiredCapabilities();
                if (desired != null && desired.length > 0) {
                    this.response.withOfferedCapabilities(Arrays.copyOf(desired, desired.length));
                }
                this.response.withMaxFrameSize(open.getMaxFrameSize());
            }
        }
    }

    public OpenExpectation withContainerId(String container) {
        this.explicitlyNullContainerId = container == null;
        return this.withContainerId(CoreMatchers.equalTo((Object)container));
    }

    public OpenExpectation withHostname(String hostname) {
        return this.withHostname(CoreMatchers.equalTo((Object)hostname));
    }

    public OpenExpectation withMaxFrameSize(int maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(maxFrameSize)));
    }

    public OpenExpectation withMaxFrameSize(long maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(maxFrameSize)));
    }

    public OpenExpectation withMaxFrameSize(UnsignedInteger maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)maxFrameSize));
    }

    public OpenExpectation withChannelMax(short channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)UnsignedShort.valueOf(channelMax)));
    }

    public OpenExpectation withChannelMax(int channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)UnsignedShort.valueOf(channelMax)));
    }

    public OpenExpectation withChannelMax(UnsignedShort channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)channelMax));
    }

    public OpenExpectation withIdleTimeOut(int idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(idleTimeout)));
    }

    public OpenExpectation withIdleTimeOut(long idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(idleTimeout)));
    }

    public OpenExpectation withIdleTimeOut(UnsignedInteger idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)idleTimeout));
    }

    public OpenExpectation withOutgoingLocales(String ... outgoingLocales) {
        return this.withOutgoingLocales(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(outgoingLocales)));
    }

    public OpenExpectation withOutgoingLocales(Symbol ... outgoingLocales) {
        return this.withOutgoingLocales(CoreMatchers.equalTo((Object)outgoingLocales));
    }

    public OpenExpectation withOutgoingLocale(String outgoingLocale) {
        return this.withOutgoingLocales(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(outgoingLocale)));
    }

    public OpenExpectation withOutgoingLocale(Symbol outgoingLocale) {
        return this.withOutgoingLocales(ArrayMatching.hasItemInArray((Object)outgoingLocale));
    }

    public OpenExpectation withIncomingLocales(String ... incomingLocales) {
        return this.withIncomingLocales(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(incomingLocales)));
    }

    public OpenExpectation withIncomingLocales(Symbol ... incomingLocales) {
        return this.withIncomingLocales(CoreMatchers.equalTo((Object)incomingLocales));
    }

    public OpenExpectation withIncomingLocale(String incomingLocale) {
        return this.withIncomingLocales(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(incomingLocale)));
    }

    public OpenExpectation withIncomingLocale(Symbol incomingLocale) {
        return this.withIncomingLocales(ArrayMatching.hasItemInArray((Object)incomingLocale));
    }

    public OpenExpectation withOfferedCapabilities(String ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(offeredCapabilities)));
    }

    public OpenExpectation withOfferedCapabilities(Symbol ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)offeredCapabilities));
    }

    public OpenExpectation withOfferedCapability(Symbol offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)offeredCapability));
    }

    public OpenExpectation withOfferedCapability(String offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(offeredCapability)));
    }

    public OpenExpectation withDesiredCapabilities(String ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(desiredCapabilities)));
    }

    public OpenExpectation withDesiredCapabilities(Symbol ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)desiredCapabilities));
    }

    public OpenExpectation withDesiredCapability(Symbol desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)desiredCapability));
    }

    public OpenExpectation withDesiredCapability(String desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(desiredCapability)));
    }

    public OpenExpectation withPropertiesMap(Map<Symbol, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(properties));
    }

    public OpenExpectation withProperties(Map<String, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(properties)));
    }

    public OpenExpectation withContainerId(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.CONTAINER_ID, m);
        return this;
    }

    public OpenExpectation withHostname(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.HOSTNAME, m);
        return this;
    }

    public OpenExpectation withMaxFrameSize(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.MAX_FRAME_SIZE, m);
        return this;
    }

    public OpenExpectation withChannelMax(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.CHANNEL_MAX, m);
        return this;
    }

    public OpenExpectation withIdleTimeOut(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.IDLE_TIME_OUT, m);
        return this;
    }

    public OpenExpectation withOutgoingLocales(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.OUTGOING_LOCALES, m);
        return this;
    }

    public OpenExpectation withIncomingLocales(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.INCOMING_LOCALES, m);
        return this;
    }

    public OpenExpectation withOfferedCapabilities(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.OFFERED_CAPABILITIES, m);
        return this;
    }

    public OpenExpectation withDesiredCapabilities(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.DESIRED_CAPABILITIES, m);
        return this;
    }

    public OpenExpectation withProperties(Matcher<?> m) {
        this.matcher.addFieldMatcher(Open.Field.PROPERTIES, m);
        return this;
    }

    public OpenExpectation withProperty(String key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    public OpenExpectation withProperty(Symbol key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Open> getExpectedTypeClass() {
        return Open.class;
    }
}

