/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;

public abstract class ListDescribedTypeMatcher
extends TypeSafeMatcher<ListDescribedType> {
    private String mismatchTextAddition;
    private final int numFields;
    private final UnsignedLong descriptorCode;
    private final Symbol descriptorSymbol;
    protected final Map<Enum<?>, Matcher<?>> fieldMatchers = new LinkedHashMap();

    public ListDescribedTypeMatcher(int numFields, UnsignedLong code, Symbol symbol) {
        this.descriptorCode = code;
        this.descriptorSymbol = symbol;
        this.numFields = numFields;
    }

    public ListDescribedTypeMatcher addFieldMatcher(Enum<?> field, Matcher<?> matcher) {
        if (field.ordinal() > this.numFields) {
            throw new IllegalArgumentException("Field enum supplied exceeds number of fields in type");
        }
        this.fieldMatchers.put(field, matcher);
        return this;
    }

    public void describeTo(Description description) {
        description.appendText(this.getDescribedTypeClass().getSimpleName() + " which matches: ").appendValue(this.fieldMatchers);
    }

    protected boolean matchesSafely(ListDescribedType received) {
        try {
            Object descriptor = received.getDescriptor();
            if (!this.descriptorCode.equals(descriptor) && !this.descriptorSymbol.equals(descriptor)) {
                this.mismatchTextAddition = "Descriptor mismatch";
                return false;
            }
            for (Map.Entry<Enum<?>, Matcher<?>> entry : this.fieldMatchers.entrySet()) {
                Matcher<?> matcher = entry.getValue();
                MatcherAssert.assertThat((String)("Field " + String.valueOf(entry.getKey()) + " value should match"), (Object)received.getFieldValue(entry.getKey().ordinal()), matcher);
            }
        }
        catch (AssertionError ae) {
            this.mismatchTextAddition = "AssertionFailure: " + ((Throwable)((Object)ae)).getMessage();
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(ListDescribedType item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual form: ").appendValue((Object)item);
        mismatchDescription.appendText("\nExpected descriptor: ").appendValue((Object)this.descriptorSymbol).appendText(" / ").appendValue((Object)this.descriptorCode);
        if (this.mismatchTextAddition != null) {
            mismatchDescription.appendText("\nAdditional info: ").appendValue((Object)this.mismatchTextAddition);
        }
    }

    protected abstract Class<?> getDescribedTypeClass();
}

