/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.messaging;

import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusDurability;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusExpiryPolicy;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.matchers.ListDescribedTypeMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class SourceMatcher
extends ListDescribedTypeMatcher {
    public SourceMatcher() {
        super(Source.Field.values().length, Source.DESCRIPTOR_CODE, Source.DESCRIPTOR_SYMBOL);
    }

    public SourceMatcher(Source source) {
        super(Source.Field.values().length, Source.DESCRIPTOR_CODE, Source.DESCRIPTOR_SYMBOL);
        this.addSourceMatchers(source);
    }

    @Override
    protected Class<?> getDescribedTypeClass() {
        return Source.class;
    }

    public SourceMatcher withAddress(String name) {
        return this.withAddress(CoreMatchers.equalTo((Object)name));
    }

    public SourceMatcher withDurable(TerminusDurability durability) {
        return this.withDurable(CoreMatchers.equalTo((Object)durability.getValue()));
    }

    public SourceMatcher withExpiryPolicy(TerminusExpiryPolicy expiry) {
        return this.withExpiryPolicy(CoreMatchers.equalTo((Object)expiry.getPolicy()));
    }

    public SourceMatcher withTimeout(int timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeout)));
    }

    public SourceMatcher withTimeout(long timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeout)));
    }

    public SourceMatcher withTimeout(UnsignedInteger timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)timeout));
    }

    public SourceMatcher withDefaultTimeout() {
        return this.withTimeout((Matcher<?>)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(), CoreMatchers.equalTo((Object)UnsignedInteger.ZERO)}));
    }

    public SourceMatcher withDynamic(boolean dynamic) {
        return this.withDynamic(CoreMatchers.equalTo((Object)dynamic));
    }

    public SourceMatcher withDynamicNodePropertiesMap(Map<Symbol, Object> properties) {
        return this.withDynamicNodeProperties(CoreMatchers.equalTo(properties));
    }

    public SourceMatcher withDynamicNodeProperties(Map<String, Object> properties) {
        return this.withDynamicNodeProperties(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(properties)));
    }

    public SourceMatcher withDistributionMode(String distributionMode) {
        return this.withDistributionMode(CoreMatchers.equalTo((Object)Symbol.valueOf(distributionMode)));
    }

    public SourceMatcher withDistributionMode(Symbol distributionMode) {
        return this.withDistributionMode(CoreMatchers.equalTo((Object)distributionMode));
    }

    public SourceMatcher withFilter(Map<String, Object> filter) {
        return this.withFilter(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(filter)));
    }

    public SourceMatcher withFilterMap(Map<Symbol, Object> filter) {
        return this.withFilter(CoreMatchers.equalTo(filter));
    }

    public SourceMatcher withDefaultOutcome(DeliveryState defaultOutcome) {
        return this.withDefaultOutcome(CoreMatchers.equalTo((Object)defaultOutcome));
    }

    public SourceMatcher withOutcomes(String ... outcomes) {
        return this.withOutcomes(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(outcomes)));
    }

    public SourceMatcher withOutcomes(Symbol ... outcomes) {
        return this.withOutcomes(CoreMatchers.equalTo((Object)outcomes));
    }

    public SourceMatcher withCapabilities(String ... capabilities) {
        return this.withCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(capabilities)));
    }

    public SourceMatcher withCapabilities(Symbol ... capabilities) {
        return this.withCapabilities(CoreMatchers.equalTo((Object)capabilities));
    }

    public SourceMatcher withAddress(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.ADDRESS, m);
        return this;
    }

    public SourceMatcher withDurable(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.DURABLE, m);
        return this;
    }

    public SourceMatcher withExpiryPolicy(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.EXPIRY_POLICY, m);
        return this;
    }

    public SourceMatcher withTimeout(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.TIMEOUT, m);
        return this;
    }

    public SourceMatcher withDynamic(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.DYNAMIC, m);
        return this;
    }

    public SourceMatcher withDynamicNodeProperties(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.DYNAMIC_NODE_PROPERTIES, m);
        return this;
    }

    public SourceMatcher withDistributionMode(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.DISTRIBUTION_MODE, m);
        return this;
    }

    public SourceMatcher withFilter(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.FILTER, m);
        return this;
    }

    public SourceMatcher withDefaultOutcome(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.DEFAULT_OUTCOME, m);
        return this;
    }

    public SourceMatcher withOutcomes(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.OUTCOMES, m);
        return this;
    }

    public SourceMatcher withCapabilities(Matcher<?> m) {
        this.addFieldMatcher(Source.Field.CAPABILITIES, m);
        return this;
    }

    private void addSourceMatchers(Source source) {
        if (source.getAddress() != null) {
            this.addFieldMatcher(Source.Field.ADDRESS, CoreMatchers.equalTo((Object)source.getAddress()));
        } else {
            this.addFieldMatcher(Source.Field.ADDRESS, CoreMatchers.nullValue());
        }
        if (source.getDurable() != null) {
            this.addFieldMatcher(Source.Field.DURABLE, CoreMatchers.equalTo((Object)source.getDurable()));
        } else {
            this.addFieldMatcher(Source.Field.DURABLE, CoreMatchers.nullValue());
        }
        if (source.getExpiryPolicy() != null) {
            this.addFieldMatcher(Source.Field.EXPIRY_POLICY, CoreMatchers.equalTo((Object)source.getExpiryPolicy()));
        } else {
            this.addFieldMatcher(Source.Field.EXPIRY_POLICY, CoreMatchers.nullValue());
        }
        if (source.getTimeout() != null) {
            this.addFieldMatcher(Source.Field.TIMEOUT, CoreMatchers.equalTo((Object)source.getTimeout()));
        } else {
            this.addFieldMatcher(Source.Field.TIMEOUT, CoreMatchers.nullValue());
        }
        this.addFieldMatcher(Source.Field.DYNAMIC, CoreMatchers.equalTo((Object)source.getDynamic()));
        if (source.getDynamicNodeProperties() != null) {
            this.addFieldMatcher(Source.Field.DYNAMIC_NODE_PROPERTIES, CoreMatchers.equalTo(source.getDynamicNodeProperties()));
        } else {
            this.addFieldMatcher(Source.Field.DYNAMIC_NODE_PROPERTIES, CoreMatchers.nullValue());
        }
        if (source.getDistributionMode() != null) {
            this.addFieldMatcher(Source.Field.DISTRIBUTION_MODE, CoreMatchers.equalTo((Object)source.getDistributionMode()));
        } else {
            this.addFieldMatcher(Source.Field.DISTRIBUTION_MODE, CoreMatchers.nullValue());
        }
        if (source.getFilter() != null) {
            this.addFieldMatcher(Source.Field.FILTER, CoreMatchers.equalTo(source.getFilter()));
        } else {
            this.addFieldMatcher(Source.Field.FILTER, CoreMatchers.nullValue());
        }
        if (source.getDefaultOutcome() != null) {
            this.addFieldMatcher(Source.Field.DEFAULT_OUTCOME, CoreMatchers.equalTo((Object)((DeliveryState)source.getDefaultOutcome())));
        } else {
            this.addFieldMatcher(Source.Field.DEFAULT_OUTCOME, CoreMatchers.nullValue());
        }
        if (source.getOutcomes() != null) {
            this.addFieldMatcher(Source.Field.OUTCOMES, CoreMatchers.equalTo((Object)source.getOutcomes()));
        } else {
            this.addFieldMatcher(Source.Field.OUTCOMES, CoreMatchers.nullValue());
        }
        if (source.getCapabilities() != null) {
            this.addFieldMatcher(Source.Field.CAPABILITIES, CoreMatchers.equalTo((Object)source.getCapabilities()));
        } else {
            this.addFieldMatcher(Source.Field.CAPABILITIES, CoreMatchers.nullValue());
        }
    }
}

