/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.DeliveryAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.FooterMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class TransferPayloadCompositeMatcher
extends TypeSafeMatcher<ByteBuffer> {
    private HeaderMatcher headersMatcher;
    private String headerMatcherFailureDescription;
    private DeliveryAnnotationsMatcher deliveryAnnotationsMatcher;
    private String deliveryAnnotationsMatcherFailureDescription;
    private MessageAnnotationsMatcher messageAnnotationsMatcher;
    private String messageAnnotationsMatcherFailureDescription;
    private PropertiesMatcher propertiesMatcher;
    private String propertiesMatcherFailureDescription;
    private ApplicationPropertiesMatcher applicationPropertiesMatcher;
    private String applicationPropertiesMatcherFailureDescription;
    private List<Matcher<ByteBuffer>> msgContentMatchers = new ArrayList<Matcher<ByteBuffer>>();
    private String msgContentMatcherFailureDescription;
    private FooterMatcher footersMatcher;
    private String footerMatcherFailureDescription;
    private Matcher<Integer> payloadLengthMatcher;
    private String payloadLengthMatcherFailureDescription;

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        ByteBuffer receivedSlice = receivedBinary.slice().asReadOnlyBuffer();
        int origLength = receivedBinary.remaining();
        int bytesConsumed = 0;
        if (this.payloadLengthMatcher != null) {
            try {
                MatcherAssert.assertThat((String)"Payload length should match", (Object)origLength, this.payloadLengthMatcher);
            }
            catch (Throwable t) {
                this.payloadLengthMatcherFailureDescription = "\nPayload Length Matcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (this.headersMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.headersMatcher.verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.headerMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to MessageHeaderMatcher: " + String.valueOf(receivedSlice);
                this.headerMatcherFailureDescription = this.headerMatcherFailureDescription + "\nMessageHeaderMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (this.deliveryAnnotationsMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.deliveryAnnotationsMatcher.verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.deliveryAnnotationsMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to DeliveryAnnotationsMatcher: " + String.valueOf(receivedSlice);
                this.deliveryAnnotationsMatcherFailureDescription = this.deliveryAnnotationsMatcherFailureDescription + "\nDeliveryAnnotationsMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (this.messageAnnotationsMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.messageAnnotationsMatcher.verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.messageAnnotationsMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to MessageAnnotationsMatcher: " + String.valueOf(receivedSlice);
                this.messageAnnotationsMatcherFailureDescription = this.messageAnnotationsMatcherFailureDescription + "\nMessageAnnotationsMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (this.propertiesMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.propertiesMatcher.verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.propertiesMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to PropertiesMatcher: " + String.valueOf(receivedSlice);
                this.propertiesMatcherFailureDescription = this.propertiesMatcherFailureDescription + "\nPropertiesMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (this.applicationPropertiesMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.applicationPropertiesMatcher.verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.applicationPropertiesMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to ApplicationPropertiesMatcher: " + String.valueOf(receivedSlice);
                this.applicationPropertiesMatcherFailureDescription = this.applicationPropertiesMatcherFailureDescription + "\nApplicationPropertiesMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        if (!this.msgContentMatchers.isEmpty()) {
            ByteBuffer slicedMsgContext = receivedSlice.slice();
            for (Matcher<ByteBuffer> msgContentMatcher : this.msgContentMatchers) {
                int originalReadableBytes = slicedMsgContext.remaining();
                boolean contentMatches = msgContentMatcher.matches((Object)slicedMsgContext);
                if (!contentMatches) {
                    StringDescription desc = new StringDescription();
                    msgContentMatcher.describeTo((Description)desc);
                    msgContentMatcher.describeMismatch((Object)receivedSlice, (Description)desc);
                    this.msgContentMatcherFailureDescription = "\nMessageContentMatcher mismatch Description:";
                    this.msgContentMatcherFailureDescription = this.msgContentMatcherFailureDescription + desc.toString();
                    return false;
                }
                receivedSlice.position(bytesConsumed += originalReadableBytes - slicedMsgContext.remaining());
            }
        }
        if (this.footersMatcher != null) {
            try {
                bytesConsumed += this.footersMatcher.verify(receivedSlice.slice());
            }
            catch (Throwable t) {
                this.footerMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to FooterMatcher: " + String.valueOf(receivedSlice);
                this.footerMatcherFailureDescription = this.footerMatcherFailureDescription + "\nFooterMatcher generated throwable: " + String.valueOf(t);
                return false;
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a Binary encoding of a Transfer frames payload, containing an AMQP message");
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form of the full Transfer frame payload: ").appendValue((Object)item);
        if (this.payloadLengthMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nPayloadLengthMatcherFailed!");
            mismatchDescription.appendText(this.payloadLengthMatcherFailureDescription);
            return;
        }
        if (this.headerMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nMessageHeadersMatcherFailed!");
            mismatchDescription.appendText(this.headerMatcherFailureDescription);
            return;
        }
        if (this.deliveryAnnotationsMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nDeliveryAnnotationsMatcherFailed!");
            mismatchDescription.appendText(this.deliveryAnnotationsMatcherFailureDescription);
            return;
        }
        if (this.messageAnnotationsMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nMessageAnnotationsMatcherFailed!");
            mismatchDescription.appendText(this.messageAnnotationsMatcherFailureDescription);
            return;
        }
        if (this.propertiesMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nPropertiesMatcherFailed!");
            mismatchDescription.appendText(this.propertiesMatcherFailureDescription);
            return;
        }
        if (this.applicationPropertiesMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nApplicationPropertiesMatcherFailed!");
            mismatchDescription.appendText(this.applicationPropertiesMatcherFailureDescription);
            return;
        }
        if (this.msgContentMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nContentMatcherFailed!");
            mismatchDescription.appendText(this.msgContentMatcherFailureDescription);
            return;
        }
        if (this.footerMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nContentMatcherFailed!");
            mismatchDescription.appendText(this.footerMatcherFailureDescription);
        }
    }

    public void setHeadersMatcher(HeaderMatcher headersMatcher) {
        this.headersMatcher = headersMatcher;
    }

    public void setDeliveryAnnotationsMatcher(DeliveryAnnotationsMatcher deliveryAnnotationsMatcher) {
        this.deliveryAnnotationsMatcher = deliveryAnnotationsMatcher;
    }

    public void setMessageAnnotationsMatcher(MessageAnnotationsMatcher msgAnnotationsMatcher) {
        this.messageAnnotationsMatcher = msgAnnotationsMatcher;
    }

    public void setPropertiesMatcher(PropertiesMatcher propsMatcher) {
        this.propertiesMatcher = propsMatcher;
    }

    public void setApplicationPropertiesMatcher(ApplicationPropertiesMatcher appPropsMatcher) {
        this.applicationPropertiesMatcher = appPropsMatcher;
    }

    public void setMessageContentMatcher(Matcher<ByteBuffer> msgContentMatcher) {
        if (this.msgContentMatchers.isEmpty()) {
            this.msgContentMatchers.add(msgContentMatcher);
        } else {
            this.msgContentMatchers.set(0, msgContentMatcher);
        }
    }

    public void addMessageContentMatcher(Matcher<ByteBuffer> msgContentMatcher) {
        this.msgContentMatchers.add(msgContentMatcher);
    }

    public void setFootersMatcher(FooterMatcher footersMatcher) {
        this.footersMatcher = footersMatcher;
    }

    public void setPayloadLengthMatcher(Matcher<Integer> payloadLengthMatcher) {
        this.payloadLengthMatcher = payloadLengthMatcher;
    }
}

