/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.types;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedBodySectionMatcher;
import org.hamcrest.Description;

public class EncodedAnyBodySectionMatcher
extends EncodedBodySectionMatcher {
    private static final Symbol AMQP_VALUE_DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:amqp-value:*");
    private static final UnsignedLong AMQP_VALUE_DESCRIPTOR_CODE = UnsignedLong.valueOf(119L);
    private static final Symbol AMQP_SEQUENCE_DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:amqp-sequence:list");
    private static final UnsignedLong AMQP_SEQUENCE_DESCRIPTOR_CODE = UnsignedLong.valueOf(118L);
    private static final Symbol DATA_DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:data:binary");
    private static final UnsignedLong DATA_DESCRIPTOR_CODE = UnsignedLong.valueOf(117L);
    private boolean allowTrailingBytes;
    private DescribedType decodedDescribedType;
    private boolean unexpectedTrailingBytes;

    public EncodedAnyBodySectionMatcher() {
        this(false);
    }

    public EncodedAnyBodySectionMatcher(boolean allowTrailingBytes) {
        this.allowTrailingBytes = allowTrailingBytes;
    }

    @Override
    public void setAllowTrailingBytes(boolean allowTrailingBytes) {
        this.allowTrailingBytes = allowTrailingBytes;
    }

    @Override
    public boolean isAllowTrailngBytes() {
        return this.allowTrailingBytes;
    }

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        int length = receivedBinary.remaining();
        Codec data = Codec.Factory.create();
        long decoded = data.decode(receivedBinary);
        this.decodedDescribedType = data.getDescribedType();
        Object descriptor = this.decodedDescribedType.getDescriptor();
        if (!(AMQP_VALUE_DESCRIPTOR_CODE.equals(descriptor) || AMQP_VALUE_DESCRIPTOR_SYMBOL.equals(descriptor) || AMQP_SEQUENCE_DESCRIPTOR_CODE.equals(descriptor) || AMQP_SEQUENCE_DESCRIPTOR_SYMBOL.equals(descriptor) || DATA_DESCRIPTOR_CODE.equals(descriptor) || DATA_DESCRIPTOR_SYMBOL.equals(descriptor))) {
            return false;
        }
        if (this.decodedDescribedType.getDescribed() == null) {
            return false;
        }
        if (decoded < (long)length && !this.allowTrailingBytes) {
            this.unexpectedTrailingBytes = true;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a body section of any AMQP Value, Sequence or Data section.");
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form: ").appendValue((Object)item);
        if (this.decodedDescribedType != null) {
            mismatchDescription.appendText("\nExpected descriptor of AMQP Value, Sequence or Data section: ");
            mismatchDescription.appendText("\nActual described type: ").appendValue((Object)this.decodedDescribedType);
        }
        if (this.unexpectedTrailingBytes) {
            mismatchDescription.appendText("\nUnexpected trailing bytes in provided bytes after decoding!");
        }
    }
}

