/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class EncodedCompositingDataSectionMatcher
extends TypeSafeMatcher<ByteBuffer> {
    private static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:data:binary");
    private static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(117L);
    private final int expectedValueSize;
    private final ByteBuffer expectedValue;
    private boolean expectTrailingBytes;
    private String decodingErrorDescription;
    private boolean unexpectedTrailingBytes;
    private boolean expectDataSectionPreamble = true;
    private int expectedCurrentDataSectionBytes = -1;
    private int expectedRemainingBytes;
    private static final int DESCRIBED_TYPE_INDICATOR = 0;

    public EncodedCompositingDataSectionMatcher(byte[] expectedValue) {
        this(ByteBuffer.wrap(Arrays.copyOf(expectedValue, expectedValue.length)).asReadOnlyBuffer());
    }

    public EncodedCompositingDataSectionMatcher(Binary expectedValue) {
        this(ByteBuffer.wrap(expectedValue.arrayCopy()).asReadOnlyBuffer());
    }

    public EncodedCompositingDataSectionMatcher(ByteBuffer expectedValue) {
        Objects.requireNonNull(expectedValue, "The expected value cannot be null for this matcher");
        this.expectedValue = expectedValue.asReadOnlyBuffer();
        this.expectedValueSize = this.expectedRemainingBytes = this.expectedValue.remaining();
    }

    public boolean isTrailingBytesExpected() {
        return this.expectTrailingBytes;
    }

    public EncodedCompositingDataSectionMatcher setExpectTrailingBytes(boolean expectTrailingBytes) {
        this.expectTrailingBytes = expectTrailingBytes;
        return this;
    }

    protected Object getExpectedValue() {
        return this.expectedValue;
    }

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        if (this.expectDataSectionPreamble) {
            Object descriptor = this.readDescribedTypeEncoding(receivedBinary);
            if (!DESCRIPTOR_CODE.equals(descriptor) && !DESCRIPTOR_SYMBOL.equals(descriptor)) {
                return false;
            }
            byte encodingCode = receivedBinary.get();
            if (encodingCode == -96) {
                this.expectedCurrentDataSectionBytes = receivedBinary.get() & 0xFF;
            } else if (encodingCode == -80) {
                this.expectedCurrentDataSectionBytes = receivedBinary.getInt();
            } else {
                this.decodingErrorDescription = "Expected to read a Binary Type but read encoding code: " + encodingCode;
                return false;
            }
            if (this.expectedCurrentDataSectionBytes > this.expectedRemainingBytes) {
                this.decodingErrorDescription = "Expected encoded Binary to indicate size of: " + this.expectedRemainingBytes + ", or less but read an encoded size of: " + this.expectedCurrentDataSectionBytes;
                return false;
            }
            this.expectDataSectionPreamble = false;
        }
        if (this.expectedRemainingBytes != 0) {
            int currentChunkSize = Math.min(this.expectedCurrentDataSectionBytes, receivedBinary.remaining());
            ByteBuffer expectedValueChunk = this.expectedValue.slice().limit(currentChunkSize);
            ByteBuffer currentChunk = receivedBinary.slice().limit(currentChunkSize);
            receivedBinary.position(receivedBinary.position() + currentChunkSize);
            this.expectedValue.position(this.expectedValue.position() + currentChunkSize);
            if (!expectedValueChunk.equals(currentChunk)) {
                return false;
            }
            this.expectedRemainingBytes -= currentChunkSize;
            this.expectedCurrentDataSectionBytes -= currentChunkSize;
            if (this.expectedRemainingBytes != 0 && this.expectedCurrentDataSectionBytes == 0) {
                this.expectDataSectionPreamble = true;
                this.expectedCurrentDataSectionBytes = -1;
            }
        }
        if (this.expectedRemainingBytes == 0 && receivedBinary.remaining() > 0 && !this.isTrailingBytesExpected()) {
            this.unexpectedTrailingBytes = true;
            return false;
        }
        return true;
    }

    private Object readDescribedTypeEncoding(ByteBuffer data) {
        byte encodingCode = data.get();
        if (encodingCode == 0) {
            encodingCode = data.get();
            switch (encodingCode) {
                case 68: {
                    return UnsignedLong.ZERO;
                }
                case 83: {
                    return UnsignedLong.valueOf(data.get() & 0xFF);
                }
                case -128: {
                    return UnsignedLong.valueOf(data.getLong());
                }
                case -93: {
                    return EncodedCompositingDataSectionMatcher.readSymbol8(data);
                }
                case -77: {
                    return EncodedCompositingDataSectionMatcher.readSymbol32(data);
                }
            }
            this.decodingErrorDescription = "Expected Unsigned Long or Symbol type but found encoding: " + encodingCode;
        } else {
            this.decodingErrorDescription = "Expected to read a Described Type but read encoding code: " + encodingCode;
        }
        return null;
    }

    private static Symbol readSymbol32(ByteBuffer buffer) {
        return EncodedCompositingDataSectionMatcher.readSymbol(buffer.getInt(), buffer);
    }

    private static Symbol readSymbol8(ByteBuffer buffer) {
        return EncodedCompositingDataSectionMatcher.readSymbol(buffer.get() & 0xFF, buffer);
    }

    private static Symbol readSymbol(int length, ByteBuffer buffer) {
        if (length == 0) {
            return Symbol.valueOf("");
        }
        byte[] symbolBytes = new byte[length];
        buffer.get(symbolBytes);
        ByteBuffer symbolBuffer = ByteBuffer.wrap(symbolBytes).asReadOnlyBuffer();
        return Symbol.getSymbol(symbolBuffer, false);
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form: ").appendValue((Object)item);
        if (this.decodingErrorDescription != null) {
            mismatchDescription.appendText("\nExpected descriptor: ").appendValue((Object)DESCRIPTOR_SYMBOL).appendText(" / ").appendValue((Object)DESCRIPTOR_CODE);
            mismatchDescription.appendText("\nError that failed the validation: ").appendValue((Object)this.decodingErrorDescription);
        }
        if (this.unexpectedTrailingBytes) {
            mismatchDescription.appendText("\nUnexpected trailing bytes in provided bytes after decoding!");
        }
    }

    public void describeTo(Description description) {
        description.appendText("a complete Binary encoding of a Data section that wraps").appendText(" an collection of bytes of eventual size {").appendValue((Object)this.expectedValueSize).appendText("}").appendText(" containing: ").appendValue(this.getExpectedValue());
    }
}

