/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class EncodedPartialDataSectionMatcher
extends TypeSafeMatcher<ByteBuffer> {
    private static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:data:binary");
    private static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(117L);
    private final boolean expectDataSectionPreamble;
    private final ByteBuffer expectedValue;
    private final int expectedEncodedSize;
    private boolean expectTrailingBytes;
    private String decodingErrorDescription;
    private boolean unexpectedTrailingBytes;
    private static final int DESCRIBED_TYPE_INDICATOR = 0;

    public EncodedPartialDataSectionMatcher(int expectedEncodedSize, byte[] expectedValue) {
        this(expectedEncodedSize, ByteBuffer.wrap(Arrays.copyOf(expectedValue, expectedValue.length)).asReadOnlyBuffer(), true);
    }

    public EncodedPartialDataSectionMatcher(int expectedEncodedSize, Binary expectedValue) {
        this(expectedEncodedSize, ByteBuffer.wrap(expectedValue.arrayCopy()).asReadOnlyBuffer(), true);
    }

    public EncodedPartialDataSectionMatcher(int expectedEncodedSize, ByteBuffer expectedValue) {
        this(expectedEncodedSize, expectedValue, true);
    }

    public EncodedPartialDataSectionMatcher(byte[] expectedValue) {
        this(-1, ByteBuffer.wrap(Arrays.copyOf(expectedValue, expectedValue.length)).asReadOnlyBuffer(), false);
    }

    public EncodedPartialDataSectionMatcher(Binary expectedValue) {
        this(-1, ByteBuffer.wrap(expectedValue.arrayCopy()).asReadOnlyBuffer(), false);
    }

    public EncodedPartialDataSectionMatcher(ByteBuffer expectedValue) {
        this(-1, expectedValue, false);
    }

    protected EncodedPartialDataSectionMatcher(int expectedEncodedSize, ByteBuffer expectedValue, boolean expectDataSectionPreamble) {
        this.expectedValue = expectedValue.asReadOnlyBuffer();
        this.expectedEncodedSize = expectedEncodedSize;
        this.expectDataSectionPreamble = expectDataSectionPreamble;
    }

    public boolean isTrailingBytesExpected() {
        return this.expectTrailingBytes;
    }

    public EncodedPartialDataSectionMatcher setExpectTrailingBytes(boolean expectTrailingBytes) {
        this.expectTrailingBytes = expectTrailingBytes;
        return this;
    }

    protected Object getExpectedValue() {
        return this.expectedValue;
    }

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        if (this.expectDataSectionPreamble) {
            Object descriptor = this.readDescribedTypeEncoding(receivedBinary);
            if (!DESCRIPTOR_CODE.equals(descriptor) && !DESCRIPTOR_SYMBOL.equals(descriptor)) {
                return false;
            }
            byte encodingCode = receivedBinary.get();
            int binaryEncodedSize = -1;
            if (encodingCode == -96) {
                binaryEncodedSize = receivedBinary.get() & 0xFF;
            } else if (encodingCode == -80) {
                binaryEncodedSize = receivedBinary.getInt();
            } else {
                this.decodingErrorDescription = "Expected to read a Binary Type but read encoding code: " + encodingCode;
                return false;
            }
            if (binaryEncodedSize != this.expectedEncodedSize) {
                this.decodingErrorDescription = "Expected encoded Binary to indicate size of: " + this.expectedEncodedSize + ", but read an encoded size of: " + binaryEncodedSize;
                return false;
            }
        }
        if (this.expectedValue != null) {
            ByteBuffer payload = receivedBinary.slice().asReadOnlyBuffer();
            receivedBinary.position(receivedBinary.position() + payload.remaining());
            if (!this.expectedValue.equals(payload)) {
                return false;
            }
        }
        if (receivedBinary.remaining() > 0 && !this.isTrailingBytesExpected()) {
            this.unexpectedTrailingBytes = true;
            return false;
        }
        return true;
    }

    private Object readDescribedTypeEncoding(ByteBuffer data) {
        byte encodingCode = data.get();
        if (encodingCode == 0) {
            encodingCode = data.get();
            switch (encodingCode) {
                case 68: {
                    return UnsignedLong.ZERO;
                }
                case 83: {
                    return UnsignedLong.valueOf(data.get() & 0xFF);
                }
                case -128: {
                    return UnsignedLong.valueOf(data.getLong());
                }
                case -93: {
                    return EncodedPartialDataSectionMatcher.readSymbol8(data);
                }
                case -77: {
                    return EncodedPartialDataSectionMatcher.readSymbol32(data);
                }
            }
            this.decodingErrorDescription = "Expected Unsigned Long or Symbol type but found encoding: " + encodingCode;
        } else {
            this.decodingErrorDescription = "Expected to read a Described Type but read encoding code: " + encodingCode;
        }
        return null;
    }

    private static Symbol readSymbol32(ByteBuffer buffer) {
        return EncodedPartialDataSectionMatcher.readSymbol(buffer.getInt(), buffer);
    }

    private static Symbol readSymbol8(ByteBuffer buffer) {
        return EncodedPartialDataSectionMatcher.readSymbol(buffer.get() & 0xFF, buffer);
    }

    private static Symbol readSymbol(int length, ByteBuffer buffer) {
        if (length == 0) {
            return Symbol.valueOf("");
        }
        byte[] symbolBytes = new byte[length];
        buffer.get(symbolBytes);
        ByteBuffer symbolBuffer = ByteBuffer.wrap(symbolBytes).asReadOnlyBuffer();
        return Symbol.getSymbol(symbolBuffer, false);
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form: ").appendValue((Object)item);
        if (this.decodingErrorDescription != null) {
            mismatchDescription.appendText("\nExpected descriptor: ").appendValue((Object)DESCRIPTOR_SYMBOL).appendText(" / ").appendValue((Object)DESCRIPTOR_CODE);
            mismatchDescription.appendText("\nError that failed the validation: ").appendValue((Object)this.decodingErrorDescription);
        }
        if (this.unexpectedTrailingBytes) {
            mismatchDescription.appendText("\nUnexpected trailing bytes in provided bytes after decoding!");
        }
    }

    public void describeTo(Description description) {
        description.appendText("a partial Binary encoding of a Data section that wraps").appendText(" an incomplete Binary of eventual size {").appendValue((Object)this.expectedEncodedSize).appendText("}").appendText(" containing: ").appendValue(this.getExpectedValue());
    }
}

