/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.netty;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.test.driver.ProtonTestClientOptions;
import org.apache.qpid.protonj2.test.driver.ProtonTestServerOptions;
import org.apache.qpid.protonj2.test.driver.netty.NettyClient;
import org.apache.qpid.protonj2.test.driver.netty.NettyServer;
import org.apache.qpid.protonj2.test.driver.netty.netty4.Netty4Client;
import org.apache.qpid.protonj2.test.driver.netty.netty4.Netty4Server;
import org.apache.qpid.protonj2.test.driver.netty.netty4.Netty4Support;
import org.apache.qpid.protonj2.test.driver.netty.netty5.Netty5Client;
import org.apache.qpid.protonj2.test.driver.netty.netty5.Netty5Server;
import org.apache.qpid.protonj2.test.driver.netty.netty5.Netty5Support;

public interface NettyIOBuilder {
    public static NettyClient createClient(ProtonTestClientOptions options, Runnable connectedHandler, Consumer<ByteBuffer> inputHandler) {
        if (Netty4Support.isAvailable()) {
            return new Netty4Client(options, connectedHandler, inputHandler);
        }
        if (Netty5Support.isAvailable()) {
            return new Netty5Client(options, connectedHandler, inputHandler);
        }
        throw new UnsupportedOperationException("Netty not available on the class path");
    }

    public static NettyServer createServer(ProtonTestServerOptions options, Runnable connectedHandler, Runnable disconnectedHandler, Consumer<ByteBuffer> inputHandler) {
        if (Netty4Support.isAvailable()) {
            return new Netty4Server(options, connectedHandler, disconnectedHandler, inputHandler);
        }
        if (Netty5Support.isAvailable()) {
            return new Netty5Server(options, connectedHandler, disconnectedHandler, inputHandler);
        }
        throw new UnsupportedOperationException("Netty not available on the class path");
    }
}

