/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.netty.netty5;

import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpServerCodec;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshakeCompletionEvent;
import io.netty5.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty5.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty5.handler.logging.LogLevel;
import io.netty5.handler.logging.LoggingHandler;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.qpid.protonj2.test.driver.ProtonTestServerOptions;
import org.apache.qpid.protonj2.test.driver.netty.NettyEventLoop;
import org.apache.qpid.protonj2.test.driver.netty.NettyServer;
import org.apache.qpid.protonj2.test.driver.netty.netty5.Netty5EventLoop;
import org.apache.qpid.protonj2.test.driver.netty.netty5.SslSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Netty5Server
implements NettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int PORT = Integer.parseInt(System.getProperty("port", "5672"));
    static final String WEBSOCKET_PATH = "/";
    static final int DEFAULT_MAX_FRAME_SIZE = 65535;
    private Netty5EventLoop eventLoop;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;
    private Channel clientChannel;
    private final ProtonTestServerOptions options;
    private int maxFrameSize = 65535;
    private String webSocketPath = "/";
    private boolean wsCompressionRequest;
    private boolean wsCompressionResponse;
    private volatile SslHandler sslHandler;
    private volatile WebSocketServerHandshakeCompletionEvent handshakeComplete;
    private final CountDownLatch handshakeCompletion = new CountDownLatch(1);
    private final AtomicBoolean started = new AtomicBoolean();
    private final Consumer<ByteBuffer> inputConsumer;
    private final Runnable connectedRunnable;
    private final Runnable disconnectedRunnable;

    public Netty5Server(ProtonTestServerOptions options, Runnable connectedRunnable, Runnable disconnectedRunnable, Consumer<ByteBuffer> inputConsumer) {
        Objects.requireNonNull(options);
        Objects.requireNonNull(inputConsumer);
        Objects.requireNonNull(connectedRunnable);
        this.options = options;
        this.connectedRunnable = connectedRunnable;
        this.disconnectedRunnable = disconnectedRunnable;
        this.inputConsumer = inputConsumer;
    }

    @Override
    public boolean isSecureServer() {
        return this.options.isSecure();
    }

    @Override
    public boolean isAcceptingConnections() {
        return this.serverChannel != null && this.serverChannel.isOpen();
    }

    @Override
    public boolean hasSecureConnection() {
        return this.sslHandler != null;
    }

    @Override
    public boolean hasClientConnection() {
        return this.clientChannel != null && this.clientChannel.isOpen();
    }

    @Override
    public int getClientPort() {
        Objects.requireNonNull(this.clientChannel);
        return ((InetSocketAddress)this.clientChannel.remoteAddress()).getPort();
    }

    @Override
    public boolean isWSCompressionActive() {
        Objects.requireNonNull(this.clientChannel);
        return this.wsCompressionRequest && this.wsCompressionResponse;
    }

    @Override
    public boolean isPeerVerified() {
        try {
            if (this.hasSecureConnection()) {
                return this.sslHandler.engine().getSession().getPeerPrincipal() != null;
            }
            return false;
        }
        catch (SSLPeerUnverifiedException unverified) {
            return false;
        }
    }

    @Override
    public SSLEngine getConnectionSSLEngine() {
        if (this.hasSecureConnection()) {
            return this.sslHandler.engine();
        }
        return null;
    }

    @Override
    public boolean isWebSocketServer() {
        return this.options.isUseWebSockets();
    }

    @Override
    public String getWebSocketPath() {
        return this.webSocketPath;
    }

    @Override
    public void setWebSocketPath(String webSocketPath) {
        this.webSocketPath = webSocketPath;
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public boolean awaitHandshakeCompletion(long delayMs) throws InterruptedException {
        return this.handshakeCompletion.await(delayMs, TimeUnit.MILLISECONDS);
    }

    public WebSocketServerHandshakeCompletionEvent getHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public URI getConnectionURI(String queryString) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("Cannot get URI of non-started server");
        }
        int port = this.getServerPort();
        String scheme = this.isWebSocketServer() ? (this.isSecureServer() ? "amqpwss" : "amqpws") : (this.isSecureServer() ? "amqps" : "amqp");
        String path = this.isWebSocketServer() ? this.getWebSocketPath() : null;
        if (queryString != null && queryString.startsWith("?")) {
            queryString = queryString.substring(1);
        }
        return new URI(scheme, null, "localhost", port, path, queryString, null);
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.bossGroup = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
            this.workerGroup = new MultithreadEventLoopGroup(NioHandler.newFactory());
            ServerBootstrap server = new ServerBootstrap();
            server.group(this.bossGroup, this.workerGroup);
            server.channel(NioServerSocketChannel.class);
            server.option(ChannelOption.SO_BACKLOG, (Object)100);
            server.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
            server.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel ch) throws Exception {
                    Netty5Server.this.serverChannel.close();
                    Netty5Server.this.clientChannel = ch;
                    Netty5Server.this.eventLoop = new Netty5EventLoop(ch.executor());
                    if (Netty5Server.this.isSecureServer()) {
                        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
                        Netty5Server.this.sslHandler = SslSupport.createServerSslHandler(null, Netty5Server.this.options);
                        channelHandlerArray[0] = Netty5Server.this.sslHandler;
                        ch.pipeline().addLast(channelHandlerArray);
                    }
                    if (Netty5Server.this.options.isUseWebSockets()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                        if (Netty5Server.this.options.isWebSocketCompression()) {
                            ch.pipeline().addLast(new ChannelHandler[]{new ServerWSCompressionObserverHandler()});
                            ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(Netty5Server.this.getWebSocketPath(), "amqp", true, Netty5Server.this.maxFrameSize)});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new NettyServerOutboundHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new NettyServerInboundHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{Netty5Server.this.getServerHandler()});
                }
            });
            this.serverChannel = (Channel)server.bind(this.options.getServerPort()).asStage().get();
            this.options.setServerPort(((InetSocketAddress)this.serverChannel.localAddress()).getPort());
        }
    }

    protected ChannelHandler getServerHandler() {
        return new SimpleChannelInboundHandler<Buffer>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                Netty5Server.this.connectedRunnable.run();
                ctx.fireChannelActive();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                Netty5Server.this.disconnectedRunnable.run();
                ctx.fireChannelInactive();
            }

            protected void messageReceived(ChannelHandlerContext ctx, Buffer input) throws Exception {
                LOG.trace("AMQP Test Server Channel read: {}", (Object)input);
                try {
                    ByteBuffer copy = ByteBuffer.allocate(input.readableBytes());
                    input.readBytes(copy);
                    Netty5Server.this.inputConsumer.accept(copy.flip().asReadOnlyBuffer());
                }
                catch (Throwable e) {
                    LOG.error("Closed AMQP Test server channel due to error: ", e);
                    ctx.channel().close();
                }
            }
        };
    }

    @Override
    public void write(ByteBuffer frame) {
        if (this.clientChannel == null || !this.clientChannel.isActive()) {
            throw new IllegalStateException("Channel is not connected or has closed");
        }
        this.clientChannel.writeAndFlush((Object)BufferAllocator.onHeapUnpooled().copyOf(frame).makeReadOnly());
    }

    @Override
    public NettyEventLoop eventLoop() {
        if (this.clientChannel == null || !this.clientChannel.isActive()) {
            throw new IllegalStateException("Channel is not connected or has closed");
        }
        return this.eventLoop;
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.started.compareAndSet(true, false)) {
            LOG.info("Syncing channel close");
            this.serverChannel.close().asStage().sync();
            if (this.clientChannel != null) {
                try {
                    if (!this.clientChannel.close().asStage().await(10L, TimeUnit.SECONDS)) {
                        LOG.info("Connected Client channel close timed out waiting for result");
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    LOG.debug("Close of connected client channel interrupted while awaiting result");
                }
            }
            int timeout = 100;
            LOG.trace("Shutting down boss group");
            this.bossGroup.shutdownGracefully(0L, (long)timeout, TimeUnit.MILLISECONDS).asStage().await((long)timeout, TimeUnit.MILLISECONDS);
            LOG.trace("Boss group shut down");
            LOG.trace("Shutting down worker group");
            this.workerGroup.shutdownGracefully(0L, (long)timeout, TimeUnit.MILLISECONDS).asStage().await((long)timeout, TimeUnit.MILLISECONDS);
            LOG.trace("Worker group shut down");
        }
    }

    @Override
    public void stopAsync() throws InterruptedException {
        if (this.started.compareAndSet(true, false)) {
            LOG.info("Closing channel asynchronously");
            this.serverChannel.close().asStage().sync();
            if (this.clientChannel != null) {
                this.clientChannel.close();
            }
            int timeout = 100;
            LOG.trace("Shutting down boss group asynchronously");
            this.bossGroup.shutdownGracefully(0L, (long)timeout, TimeUnit.MILLISECONDS);
            LOG.trace("Shutting down worker group asynchronously");
            this.workerGroup.shutdownGracefully(0L, (long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.stop();
    }

    @Override
    public void disconnectClient() throws Exception {
        if (!this.started.get() || !this.serverChannel.isOpen()) {
            throw new IllegalStateException("Server must be currently active in order to reset");
        }
        if (this.clientChannel != null) {
            try {
                if (!this.clientChannel.close().asStage().await(10L, TimeUnit.SECONDS)) {
                    LOG.info("Connected Client channel close timed out waiting for result");
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                LOG.debug("Close of connected client channel interrupted while awaiting result");
            }
            finally {
                this.clientChannel = null;
            }
        }
    }

    @Override
    public int getServerPort() {
        if (!this.started.get()) {
            throw new IllegalStateException("Cannot get server port of non-started server");
        }
        return this.options.getServerPort();
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        if (response.status().code() != 200) {
            byte[] status = response.status().toString().getBytes(StandardCharsets.UTF_8);
            response.payload().writeBytes(status);
            HttpUtil.setContentLength((HttpMessage)response, (long)response.payload().readableBytes());
        }
        Future f = ctx.channel().writeAndFlush((Object)response);
        if (!HttpUtil.isKeepAlive((HttpMessage)request) || response.status().code() != 200) {
            f.addListener((Object)ctx.channel(), ChannelFutureListeners.CLOSE);
        }
    }

    protected SslHandler getSslHandler() {
        return this.sslHandler;
    }

    private class ServerWSCompressionObserverHandler
    extends ChannelHandlerAdapter {
        final String WS_EXTENSIONS_SECTION = "sec-websocket-extensions";
        final String WS_PERMESSAGE_DEFLATE = "permessage-deflate";
        final String WS_UPGRADE = "upgrade";

        private ServerWSCompressionObserverHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object message) {
            FullHttpRequest request;
            HttpHeaders headers;
            if (message instanceof FullHttpRequest && (headers = (request = (FullHttpRequest)message).headers()).contains((CharSequence)"upgrade") && headers.contains((CharSequence)"sec-websocket-extensions")) {
                Netty5Server.this.wsCompressionRequest = headers.get((CharSequence)"sec-websocket-extensions").toString().contains("permessage-deflate");
            }
            ctx.fireChannelRead(message);
        }

        public Future<Void> write(ChannelHandlerContext context, Object message) {
            FullHttpResponse response;
            HttpHeaders headers;
            if (message instanceof FullHttpResponse && (headers = (response = (FullHttpResponse)message).headers()).contains((CharSequence)"upgrade") && headers.contains((CharSequence)"sec-websocket-extensions")) {
                Netty5Server.this.wsCompressionResponse = headers.get((CharSequence)"sec-websocket-extensions").toString().contains("permessage-deflate");
            }
            return context.write(message);
        }
    }

    private class NettyServerInboundHandler
    extends ChannelHandlerAdapter {
        private NettyServerInboundHandler() {
        }

        public void channelInboundEvent(ChannelHandlerContext context, Object payload) {
            if (payload instanceof WebSocketServerHandshakeCompletionEvent) {
                Netty5Server.this.handshakeComplete = (WebSocketServerHandshakeCompletionEvent)payload;
                Netty5Server.this.handshakeCompletion.countDown();
            }
        }

        public void channelActive(final ChannelHandlerContext ctx) {
            LOG.info("NettyServerHandler -> New active channel: {}", (Object)ctx.channel());
            SslHandler handler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            if (handler != null) {
                handler.handshakeFuture().addListener((FutureListener)new FutureListener<Channel>(){

                    public void operationComplete(Future<? extends Channel> future) throws Exception {
                        LOG.info("Server -> SSL handshake completed. Succeeded: {}", (Object)future.isSuccess());
                        if (!future.isSuccess()) {
                            ctx.close();
                        }
                    }
                });
            }
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            LOG.info("NettyServerHandler: channel has gone inactive: {}", (Object)ctx.channel());
            ctx.close();
            ctx.fireChannelInactive();
            Netty5Server.this.clientChannel = null;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            LOG.trace("NettyServerHandler: Channel read: {}", msg);
            if (msg instanceof WebSocketFrame) {
                WebSocketFrame frame = (WebSocketFrame)msg;
                ctx.fireChannelRead((Object)frame.binaryData());
            } else if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                Netty5Server.sendHttpResponse(ctx, request, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, DefaultBufferAllocators.onHeapAllocator().allocate(0)));
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.flush();
        }

        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.info("NettyServerHandler: NettyServerHandlerException caught on channel: {}", (Object)ctx.channel());
            cause.printStackTrace();
            ctx.close();
        }
    }

    private class NettyServerOutboundHandler
    extends ChannelHandlerAdapter {
        private NettyServerOutboundHandler() {
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            LOG.trace("NettyServerHandler: Channel write: {}", msg);
            if (Netty5Server.this.isWebSocketServer() && msg instanceof Buffer) {
                if (Netty5Server.this.options.isFragmentWrites()) {
                    Buffer orig = (Buffer)msg;
                    int origIndex = orig.readerOffset();
                    int split = orig.readableBytes() / 2;
                    Buffer part1 = orig.copy(origIndex, split);
                    LOG.trace("NettyServerHandler: Part1: {}", (Object)part1);
                    orig.readerOffset(origIndex + split);
                    LOG.trace("NettyServerHandler: Part2: {}", (Object)orig);
                    BinaryWebSocketFrame frame1 = new BinaryWebSocketFrame(false, 0, part1);
                    ctx.writeAndFlush((Object)frame1);
                    ContinuationWebSocketFrame frame2 = new ContinuationWebSocketFrame(true, 0, orig);
                    return ctx.write((Object)frame2);
                }
                BinaryWebSocketFrame frame = new BinaryWebSocketFrame((Buffer)msg);
                return ctx.write((Object)frame);
            }
            return ctx.write(msg);
        }
    }
}

