/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ServiceLoader;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.client.TransportProvider;
import org.apache.qpid.amqp_1_0.client.TransportProviderFactory;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.ConnectionHandler;
import org.apache.qpid.amqp_1_0.framing.ExceptionHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.Container;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.Predicate;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class Connection
implements ExceptionHandler {
    private static final int MAX_FRAME_SIZE = 65536;
    private String _address;
    private ConnectionEndpoint _conn;
    private int _sessionCount;
    private Runnable _connectionErrorTask;
    private Error _socketError;

    public Connection(String address, int port, String username, String password) throws ConnectionException {
        this(address, port, username, password, 65536);
    }

    public Connection(String address, int port, String username, String password, String remoteHostname) throws ConnectionException {
        this(address, port, username, password, 65536, new Container(), remoteHostname);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, new Container());
    }

    public Connection(String address, int port, String username, String password, Container container) throws ConnectionException {
        this(address, port, username, password, 65536, container);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize, Container container) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, container, null);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize, Container container, String remoteHostname) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, container, remoteHostname, false, -1);
    }

    public Connection(String address, int port, String username, String password, Container container, boolean ssl) throws ConnectionException {
        this(address, port, username, password, 65536, container, null, ssl, -1);
    }

    public Connection(String address, int port, String username, String password, String remoteHost, boolean ssl) throws ConnectionException {
        this(address, port, username, password, 65536, new Container(), remoteHost, ssl, -1);
    }

    public Connection(String address, int port, String username, String password, Container container, String remoteHost, boolean ssl, int channelMax) throws ConnectionException {
        this(address, port, username, password, 65536, container, remoteHost, ssl, channelMax);
    }

    public Connection(String protocol, String address, int port, String username, String password, Container container, String remoteHost, SSLContext sslContext, int channelMax) throws ConnectionException {
        this(protocol, address, port, username, password, 65536, container, remoteHost, sslContext, channelMax);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize, Container container, String remoteHostname, boolean ssl, int channelMax) throws ConnectionException {
        this(ssl ? "amqp" : "amqps", address, port, username, password, maxFrameSize, container, remoteHostname, Connection.getSslContext(ssl), channelMax);
    }

    private static SSLContext getSslContext(boolean ssl) throws ConnectionException {
        try {
            return ssl ? SSLContext.getDefault() : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectionException(e);
        }
    }

    public Connection(String protocol, String address, int port, final String username, String password, int maxFrameSize, Container container, String remoteHostname, SSLContext sslContext, int channelMax) throws ConnectionException {
        this._address = address;
        Principal principal = username == null ? null : new Principal(){

            @Override
            public String getName() {
                return username;
            }
        };
        this._conn = new ConnectionEndpoint(container, principal, password);
        if (channelMax >= 0) {
            this._conn.setChannelMax((short)channelMax);
        }
        this._conn.setDesiredMaxFrameSize(UnsignedInteger.valueOf((int)maxFrameSize));
        this._conn.setRemoteHostname(remoteHostname);
        ConnectionHandler.FrameOutput out = new ConnectionHandler.FrameOutput(this._conn);
        if (this._conn.requiresSASL()) {
            ConnectionHandler.FrameOutput saslOut = new ConnectionHandler.FrameOutput(this._conn);
            ConnectionHandler.SequentialBytesSource src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 3, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter(saslOut.asFrameSource(), (ValueWriter.Registry)this._conn.getDescribedTypeRegistry()), new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter(out.asFrameSource(), (ValueWriter.Registry)this._conn.getDescribedTypeRegistry())});
            this._conn.setSaslFrameOutput((FrameOutputHandler)saslOut);
        } else {
            ConnectionHandler.SequentialBytesSource src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter(out.asFrameSource(), (ValueWriter.Registry)this._conn.getDescribedTypeRegistry())});
        }
        TransportProvider transportProvider = this.getTransportProvider(protocol);
        transportProvider.connect(this._conn, address, port, sslContext, this);
        try {
            this._conn.open();
        }
        catch (RuntimeException e) {
            transportProvider.close();
        }
    }

    private TransportProvider getTransportProvider(String protocol) throws ConnectionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader<TransportProviderFactory> providerFactories = ServiceLoader.load(TransportProviderFactory.class, classLoader);
        for (TransportProviderFactory tpf : providerFactories) {
            if (!tpf.getSupportedTransports().contains(protocol)) continue;
            return tpf.getProvider(protocol);
        }
        throw new ConnectionException("Unknown protocol: " + protocol);
    }

    private Connection(ConnectionEndpoint endpoint) {
        this._conn = endpoint;
    }

    public Session createSession() throws ConnectionException {
        this.checkNotClosed();
        Session session = new Session(this, String.valueOf(this._sessionCount++));
        return session;
    }

    void checkNotClosed() throws ConnectionClosedException {
        if (this.getEndpoint().isClosed()) {
            Error remoteError = this.getEndpoint().getRemoteError();
            if (remoteError == null) {
                remoteError = new Error();
                remoteError.setDescription("Connection closed for unknown reason");
            }
            throw new ConnectionClosedException(remoteError);
        }
    }

    public ConnectionEndpoint getEndpoint() {
        return this._conn;
    }

    public void awaitOpen() throws TimeoutException, InterruptedException {
        this.getEndpoint().waitUntil(new Predicate(){

            public boolean isSatisfied() {
                return Connection.this.getEndpoint().isOpen() || Connection.this.getEndpoint().isClosed();
            }
        });
    }

    public void close() throws ConnectionErrorException {
        this._conn.close();
        try {
            this._conn.waitUntil(new Predicate(){

                public boolean isSatisfied() {
                    return Connection.this._conn.closedForInput();
                }
            });
        }
        catch (InterruptedException e) {
            throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Interrupted while waiting for connection closure");
        }
        catch (TimeoutException e) {
            throw new ConnectionErrorException((ErrorCondition)AmqpError.INTERNAL_ERROR, "Timed out while waiting for connection closure");
        }
        if (this._conn.getRemoteError() != null) {
            throw new ConnectionErrorException(this._conn.getRemoteError());
        }
    }

    public void setConnectionErrorTask(Runnable connectionErrorTask) {
        this._connectionErrorTask = connectionErrorTask;
    }

    public Error getConnectionError() {
        return this._socketError;
    }

    public void handleException(Exception exception) {
        Error socketError = new Error();
        socketError.setDescription(exception.getClass() + ": " + exception.getMessage());
        socketError.setCondition((ErrorCondition)ConnectionError.SOCKET_ERROR);
        this._socketError = socketError;
        if (this._connectionErrorTask != null) {
            Thread thread = new Thread(this._connectionErrorTask);
            thread.start();
        }
    }
}

