/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.LinkEventListener;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkListener;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.transaction.Declare;
import org.apache.qpid.amqp_1_0.type.transaction.Declared;
import org.apache.qpid.amqp_1_0.type.transaction.Discharge;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class TransactionController
implements DeliveryStateHandler {
    private static final Binary DELIVERY_TAG = new Binary(new byte[]{0});
    private SendingLinkEndpoint _endpoint;
    private Session _session;
    private volatile DeliveryState _state;
    private boolean _received;
    private Error _error;

    public TransactionController(Session session, SendingLinkEndpoint tcLinkEndpoint) {
        this._session = session;
        this._endpoint = tcLinkEndpoint;
        this._endpoint.setDeliveryStateHandler((DeliveryStateHandler)this);
        this._endpoint.setLinkEventListener((LinkEventListener)new SendingLinkListener(){

            public void flowStateChanged() {
            }

            public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
                TransactionController.this.remoteDetached(detach);
            }
        });
    }

    public Transaction beginTransaction() throws LinkDetachedException {
        Binary txnId = this.declare();
        return new Transaction(this, txnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binary declare() throws LinkDetachedException {
        Object lock;
        SectionEncoder encoder = this._session.getSectionEncoder();
        AmqpValue section = new AmqpValue((Object)new Declare());
        Transfer transfer = new Transfer();
        transfer.setPayload(section.encode(encoder).asByteBuffer());
        transfer.setDeliveryTag(DELIVERY_TAG);
        transfer.setSettled(Boolean.FALSE);
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.hasCreditToSend()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {}
            }
            this._state = null;
            this._received = false;
            this._endpoint.transfer(transfer);
        }
        this.waitForResponse();
        return ((Declared)this._state).getTxnId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse() throws LinkDetachedException {
        TransactionController transactionController = this;
        synchronized (transactionController) {
            while (!this._received && !this._endpoint.isDetached()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this._received && this._endpoint.isDetached()) {
            throw new LinkDetachedException(this._error);
        }
    }

    private synchronized void remoteDetached(Detach detach) {
        if (detach != null && detach.getError() != null) {
            this._error = detach.getError();
            this.notifyAll();
        }
    }

    public void commit(Transaction transaction) throws LinkDetachedException {
        this.discharge(transaction.getTxnId(), false);
    }

    public void rollback(Transaction transaction) throws LinkDetachedException {
        this.discharge(transaction.getTxnId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discharge(Binary txnId, boolean fail) throws LinkDetachedException {
        Object lock;
        Discharge discharge = new Discharge();
        discharge.setTxnId(txnId);
        discharge.setFail(Boolean.valueOf(fail));
        SectionEncoder encoder = this._session.getSectionEncoder();
        AmqpValue section = new AmqpValue((Object)discharge);
        Transfer transfer = new Transfer();
        transfer.setPayload(section.encode(encoder).asByteBuffer());
        transfer.setDeliveryTag(DELIVERY_TAG);
        transfer.setSettled(Boolean.FALSE);
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.hasCreditToSend() && !this._endpoint.isDetached()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this._endpoint.isDetached()) {
                throw new LinkDetachedException(this._error);
            }
            this._state = null;
            this._received = false;
            this._endpoint.transfer(transfer);
        }
        this.waitForResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        TransactionController transactionController = this;
        synchronized (transactionController) {
            this._state = state;
            this._received = true;
            if (!Boolean.TRUE.equals(settled)) {
                this._endpoint.updateDisposition(deliveryTag, state, true);
            }
            this.notifyAll();
        }
    }

    public void close() {
        this._endpoint.close();
    }
}

