/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.codec.VariableWidthWriter;
import org.apache.qpid.amqp_1_0.type.Symbol;

public class SymbolArrayWriter
extends VariableWidthWriter<Symbol[]> {
    private int _length;
    private byte[] _encodedVal;
    private static ValueWriter.Factory<Symbol[]> FACTORY = new ValueWriter.Factory<Symbol[]>(){

        @Override
        public ValueWriter<Symbol[]> newInstance(ValueWriter.Registry registry) {
            return new SymbolArrayWriter();
        }
    };

    @Override
    protected void clearValue() {
        this._encodedVal = null;
    }

    @Override
    protected boolean hasValue() {
        return this._encodedVal != null;
    }

    @Override
    protected byte getFourOctetEncodingCode() {
        return -16;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -32;
    }

    @Override
    protected int getLength() {
        return this._length;
    }

    @Override
    protected void writeBytes(ByteBuffer buf, int offset, int length) {
        buf.put(this._encodedVal, offset, length);
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public void setValue(Symbol[] value) {
        boolean useSmallConstructor = this.useSmallConstructor(value);
        boolean isSmall = useSmallConstructor && this.canFitInSmall(value);
        this._length = isSmall ? 2 : 5;
        for (Symbol symbol : value) {
            this._length += symbol.length();
        }
        this._length += value.length * (useSmallConstructor ? 1 : 4);
        this._encodedVal = new byte[this._length];
        ByteBuffer buf = ByteBuffer.wrap(this._encodedVal);
        if (isSmall) {
            buf.put((byte)value.length);
            buf.put((byte)-93);
        } else {
            buf.putInt(value.length);
            buf.put((byte)-77);
        }
        for (Symbol symbol : value) {
            if (isSmall) {
                buf.put((byte)symbol.length());
            } else {
                buf.putInt(symbol.length());
            }
            for (int i = 0; i < symbol.length(); ++i) {
                buf.put((byte)symbol.charAt(i));
            }
        }
        super.setValue(value);
    }

    private boolean useSmallConstructor(Symbol[] value) {
        for (Symbol sym : value) {
            if (sym.length() <= 255) continue;
            return false;
        }
        return true;
    }

    private boolean canFitInSmall(Symbol[] value) {
        if (value.length >= 127) {
            return false;
        }
        int remaining = 253 - value.length;
        for (Symbol symbol : value) {
            if ((remaining -= symbol.length()) >= 0) continue;
            return false;
        }
        return true;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Symbol[].class, FACTORY);
    }
}

