/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;

public class UnsignedByteWriter
implements ValueWriter<UnsignedByte> {
    private int _written;
    private byte _value;
    private static ValueWriter.Factory<UnsignedByte> FACTORY = new ValueWriter.Factory<UnsignedByte>(){

        @Override
        public ValueWriter<UnsignedByte> newInstance(ValueWriter.Registry registry) {
            return new UnsignedByteWriter();
        }
    };

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        switch (this._written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put((byte)80);
            }
            case 1: {
                if (buffer.hasRemaining()) {
                    buffer.put(this._value);
                    this._written = 2;
                    break;
                }
                this._written = 1;
            }
        }
        return 2;
    }

    @Override
    public void setValue(UnsignedByte value) {
        this._written = 0;
        this._value = value.byteValue();
    }

    @Override
    public boolean isComplete() {
        return this._written == 2;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(UnsignedByte.class, FACTORY);
    }
}

