/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.ExceptionEvent;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.ConfiguredObjectHelper;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreRecoveryHandler;
import org.apache.qpid.server.store.State;
import org.apache.qpid.server.store.StateManager;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMemoryMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogRecoveryHandler;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.berkeleydb.entry.PreparedTransaction;
import org.apache.qpid.server.store.berkeleydb.entry.QueueEntryKey;
import org.apache.qpid.server.store.berkeleydb.entry.Xid;
import org.apache.qpid.server.store.berkeleydb.tuple.ConfiguredObjectBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.ContentBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.MessageMetaDataBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.PreparedTransactionBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.QueueEntryBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.UUIDTupleBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.XidBinding;
import org.apache.qpid.server.store.berkeleydb.upgrade.Upgrader;
import org.apache.qpid.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBDBMessageStore
implements MessageStore {
    private static final Logger LOGGER = Logger.getLogger(AbstractBDBMessageStore.class);
    private static final int LOCK_RETRY_ATTEMPTS = 5;
    public static final int VERSION = 6;
    private static final Map<String, String> ENVCONFIG_DEFAULTS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("je.lock.nLockTables", "7");
        }
    });
    private Environment _environment;
    private String CONFIGURED_OBJECTS = "CONFIGURED_OBJECTS";
    private String MESSAGEMETADATADB_NAME = "MESSAGE_METADATA";
    private String MESSAGECONTENTDB_NAME = "MESSAGE_CONTENT";
    private String DELIVERYDB_NAME = "QUEUE_ENTRIES";
    private String BRIDGEDB_NAME = "BRIDGES";
    private String LINKDB_NAME = "LINKS";
    private String XIDDB_NAME = "XIDS";
    private Database _configuredObjectsDb;
    private Database _messageMetaDataDb;
    private Database _messageContentDb;
    private Database _deliveryDb;
    private Database _bridgeDb;
    private Database _linkDb;
    private Database _xidDb;
    private final AtomicLong _messageId = new AtomicLong(0L);
    protected final StateManager _stateManager;
    private MessageStoreRecoveryHandler _messageRecoveryHandler;
    private TransactionLogRecoveryHandler _tlogRecoveryHandler;
    private ConfigurationRecoveryHandler _configRecoveryHandler;
    private long _totalStoreSize;
    private boolean _limitBusted;
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;
    private final EventManager _eventManager = new EventManager();
    private String _storeLocation;
    private ConfiguredObjectHelper _configuredObjectHelper = new ConfiguredObjectHelper();
    private Map<String, String> _envConfigMap;

    public AbstractBDBMessageStore() {
        this._stateManager = new StateManager(this._eventManager);
    }

    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration storeConfiguration) throws Exception {
        this._stateManager.attainState(State.INITIALISING);
        this._configRecoveryHandler = recoveryHandler;
        this.configure(name, storeConfiguration);
    }

    public void configureMessageStore(String name, MessageStoreRecoveryHandler messageRecoveryHandler, TransactionLogRecoveryHandler tlogRecoveryHandler, Configuration storeConfiguration) throws Exception {
        this._messageRecoveryHandler = messageRecoveryHandler;
        this._tlogRecoveryHandler = tlogRecoveryHandler;
        this._stateManager.attainState(State.INITIALISED);
    }

    public synchronized void activate() throws Exception {
        this._stateManager.attainState(State.ACTIVATING);
        this.recoverConfig(this._configRecoveryHandler);
        this.recoverMessages(this._messageRecoveryHandler);
        this.recoverQueueEntries(this._tlogRecoveryHandler);
        this._stateManager.attainState(State.ACTIVE);
    }

    public Transaction newTransaction() {
        return new BDBTransaction();
    }

    public void configure(String name, Configuration storeConfig) throws Exception {
        File environmentPath;
        String storeLocation = storeConfig.getString("environment-path", System.getProperty("QPID_WORK") + File.separator + "bdbstore" + File.separator + name);
        this._persistentSizeHighThreshold = storeConfig.getLong("overfull-size", Long.MAX_VALUE);
        this._persistentSizeLowThreshold = storeConfig.getLong("underfull-size", this._persistentSizeHighThreshold);
        if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
            this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
        }
        if (!(environmentPath = new File(storeLocation)).exists() && !environmentPath.mkdirs()) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        this._storeLocation = storeLocation;
        this._envConfigMap = this.getConfigMap(ENVCONFIG_DEFAULTS, storeConfig, "envConfig");
        LOGGER.info((Object)"Configuring BDB message store");
        this.setupStore(environmentPath, name);
    }

    protected Map<String, String> getConfigMap(Map<String, String> defaultConfig, Configuration config, String prefix) throws ConfigurationException {
        List argumentNames = config.getList(prefix + ".name");
        List argumentValues = config.getList(prefix + ".value");
        int initialSize = argumentNames.size() + defaultConfig.size();
        HashMap<String, String> attributes = new HashMap<String, String>(initialSize);
        attributes.putAll(defaultConfig);
        for (int i = 0; i < argumentNames.size(); ++i) {
            String argName = argumentNames.get(i).toString();
            String argValue = argumentValues.get(i).toString();
            attributes.put(argName, argValue);
        }
        return Collections.unmodifiableMap(attributes);
    }

    public String getStoreLocation() {
        return this._storeLocation;
    }

    void startWithNoRecover() throws AMQStoreException {
        this._stateManager.attainState(State.INITIALISING);
        this._stateManager.attainState(State.INITIALISED);
        this._stateManager.attainState(State.ACTIVATING);
        this._stateManager.attainState(State.ACTIVE);
    }

    protected void setupStore(File storePath, String name) throws DatabaseException, AMQStoreException {
        this._environment = this.createEnvironment(storePath);
        new Upgrader(this._environment, name).upgradeIfNecessary();
        this.openDatabases();
        this._totalStoreSize = this.getSizeOnDisk();
    }

    protected abstract Environment createEnvironment(File var1) throws DatabaseException;

    public Environment getEnvironment() {
        return this._environment;
    }

    private void openDatabases() throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        dbConfig.setReadOnly(false);
        this._configuredObjectsDb = this.openDatabase(this.CONFIGURED_OBJECTS, dbConfig);
        this._messageMetaDataDb = this.openDatabase(this.MESSAGEMETADATADB_NAME, dbConfig);
        this._messageContentDb = this.openDatabase(this.MESSAGECONTENTDB_NAME, dbConfig);
        this._deliveryDb = this.openDatabase(this.DELIVERYDB_NAME, dbConfig);
        this._linkDb = this.openDatabase(this.LINKDB_NAME, dbConfig);
        this._bridgeDb = this.openDatabase(this.BRIDGEDB_NAME, dbConfig);
        this._xidDb = this.openDatabase(this.XIDDB_NAME, dbConfig);
    }

    private Database openDatabase(String dbName, DatabaseConfig dbConfig) {
        return dbConfig.getReadOnly() && !this._environment.getDatabaseNames().contains(dbName) ? null : this._environment.openDatabase(null, dbName, dbConfig);
    }

    public void close() throws Exception {
        this._stateManager.attainState(State.CLOSING);
        this.closeInternal();
        this._stateManager.attainState(State.CLOSED);
    }

    protected void closeInternal() throws Exception {
        if (this._messageMetaDataDb != null) {
            LOGGER.info((Object)"Closing message metadata database");
            this._messageMetaDataDb.close();
        }
        if (this._messageContentDb != null) {
            LOGGER.info((Object)"Closing message content database");
            this._messageContentDb.close();
        }
        if (this._configuredObjectsDb != null) {
            LOGGER.info((Object)"Closing configurable objects database");
            this._configuredObjectsDb.close();
        }
        if (this._deliveryDb != null) {
            LOGGER.info((Object)"Close delivery database");
            this._deliveryDb.close();
        }
        if (this._bridgeDb != null) {
            LOGGER.info((Object)"Close bridge database");
            this._bridgeDb.close();
        }
        if (this._linkDb != null) {
            LOGGER.info((Object)"Close link database");
            this._linkDb.close();
        }
        if (this._xidDb != null) {
            LOGGER.info((Object)"Close xid database");
            this._xidDb.close();
        }
        this.closeEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeEnvironment() throws DatabaseException {
        if (this._environment != null) {
            try {
                this._environment.cleanLog();
            }
            finally {
                this._environment.close();
            }
        }
    }

    private void recoverConfig(ConfigurationRecoveryHandler recoveryHandler) throws AMQStoreException {
        try {
            List<ConfiguredObjectRecord> configuredObjects = this.loadConfiguredObjects();
            ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh = recoveryHandler.begin((MessageStore)this);
            this._configuredObjectHelper.recoverExchanges(erh, configuredObjects);
            ConfigurationRecoveryHandler.QueueRecoveryHandler qrh = erh.completeExchangeRecovery();
            this._configuredObjectHelper.recoverQueues(qrh, configuredObjects);
            ConfigurationRecoveryHandler.BindingRecoveryHandler brh = qrh.completeQueueRecovery();
            this._configuredObjectHelper.recoverBindings(brh, configuredObjects);
            brh.completeBindingRecovery();
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfiguredObjectRecord> loadConfiguredObjects() throws DatabaseException {
        Cursor cursor = null;
        ArrayList<ConfiguredObjectRecord> results = new ArrayList<ConfiguredObjectRecord>();
        try {
            cursor = this._configuredObjectsDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            while (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                ConfiguredObjectRecord configuredObject = (ConfiguredObjectRecord)ConfiguredObjectBinding.getInstance().entryToObject(value);
                UUID id = (UUID)UUIDTupleBinding.getInstance().entryToObject(key);
                configuredObject.setId(id);
                results.add(configuredObject);
            }
            this.closeCursorSafely(cursor);
        }
        catch (Throwable throwable) {
            this.closeCursorSafely(cursor);
            throw throwable;
        }
        return results;
    }

    private void closeCursorSafely(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    private void recoverMessages(MessageStoreRecoveryHandler msrh) throws DatabaseException {
        MessageStoreRecoveryHandler.StoredMessageRecoveryHandler mrh = msrh.begin();
        Cursor cursor = null;
        try {
            cursor = this._messageMetaDataDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            MessageMetaDataBinding valueBinding = MessageMetaDataBinding.getInstance();
            long maxId = 0L;
            while (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                long messageId = LongBinding.entryToLong((DatabaseEntry)key);
                StorableMessageMetaData metaData = (StorableMessageMetaData)valueBinding.entryToObject(value);
                StoredBDBMessage message = new StoredBDBMessage(messageId, metaData, true);
                mrh.message((StoredMessage)message);
                maxId = Math.max(maxId, messageId);
            }
            this._messageId.set(maxId);
            this.closeCursorSafely(cursor);
        }
        catch (DatabaseException e) {
            try {
                LOGGER.error((Object)("Database Error: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeCursorSafely(cursor);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverQueueEntries(TransactionLogRecoveryHandler recoveryHandler) throws DatabaseException {
        TransactionLogRecoveryHandler.QueueEntryRecoveryHandler qerh = recoveryHandler.begin((MessageStore)this);
        ArrayList<QueueEntryKey> entries = new ArrayList<QueueEntryKey>();
        Cursor cursor = null;
        try {
            cursor = this._deliveryDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
            DatabaseEntry value = new DatabaseEntry();
            while (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                QueueEntryKey qek = (QueueEntryKey)keyBinding.entryToObject(key);
                entries.add(qek);
            }
            try {
                cursor.close();
            }
            finally {
                cursor = null;
            }
            for (QueueEntryKey entry : entries) {
                UUID queueId = entry.getQueueId();
                long messageId = entry.getMessageId();
                qerh.queueEntry(queueId, messageId);
            }
            this.closeCursorSafely(cursor);
        }
        catch (DatabaseException e) {
            try {
                LOGGER.error((Object)("Database Error: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeCursorSafely(cursor);
                throw throwable;
            }
        }
        TransactionLogRecoveryHandler.DtxRecordRecoveryHandler dtxrh = qerh.completeQueueEntryRecovery();
        cursor = null;
        try {
            cursor = this._xidDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            XidBinding keyBinding = XidBinding.getInstance();
            PreparedTransactionBinding valueBinding = new PreparedTransactionBinding();
            DatabaseEntry value = new DatabaseEntry();
            while (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                Xid xid = (Xid)keyBinding.entryToObject(key);
                PreparedTransaction preparedTransaction = (PreparedTransaction)valueBinding.entryToObject(value);
                dtxrh.dtxRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId(), preparedTransaction.getEnqueues(), preparedTransaction.getDequeues());
            }
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)("Database Error: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            this.closeCursorSafely(cursor);
        }
        dtxrh.completeDtxRecordRecovery();
    }

    public void removeMessage(long messageId, boolean sync) throws AMQStoreException {
        boolean complete = false;
        com.sleepycat.je.Transaction tx = null;
        Random rand = null;
        int attempts = 0;
        try {
            do {
                tx = null;
                try {
                    OperationStatus status;
                    tx = this._environment.beginTransaction(null, null);
                    DatabaseEntry key = new DatabaseEntry();
                    LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Removing message id " + messageId));
                    }
                    if ((status = this._messageMetaDataDb.delete(tx, key)) == OperationStatus.NOTFOUND) {
                        LOGGER.info((Object)("Message not found (attempt to remove failed - probably application initiated rollback) " + messageId));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Deleted metadata for message " + messageId));
                    }
                    DatabaseEntry contentKeyEntry = new DatabaseEntry();
                    LongBinding.longToEntry((long)messageId, (DatabaseEntry)contentKeyEntry);
                    this._messageContentDb.delete(tx, contentKeyEntry);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Deleted content for message " + messageId));
                    }
                    this.commit(tx, sync);
                    complete = true;
                    tx = null;
                }
                catch (LockConflictException e) {
                    try {
                        if (tx != null) {
                            tx.abort();
                        }
                    }
                    catch (DatabaseException e2) {
                        LOGGER.warn((Object)"Unable to abort transaction after LockConflictExcption", (Throwable)e2);
                        throw e;
                    }
                    LOGGER.warn((Object)("Lock timeout exception. Retrying (attempt " + (attempts + 1) + " of " + 5 + ") " + (Object)((Object)e)));
                    if (++attempts < 5) {
                        if (rand == null) {
                            rand = new Random();
                        }
                        try {
                            Thread.sleep(500L + (long)(500.0 * rand.nextDouble()));
                        }
                        catch (InterruptedException e1) {}
                        continue;
                    }
                    throw e;
                }
            } while (!complete);
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)"Unexpected BDB exception", (Throwable)e);
            throw new AMQStoreException("Error removing message with id " + messageId + " from database: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (tx != null) {
                try {
                    tx.abort();
                    tx = null;
                }
                catch (DatabaseException e1) {
                    throw new AMQStoreException("Error aborting transaction " + (Object)((Object)e1), (Throwable)e1);
                }
            }
        }
    }

    public void createExchange(Exchange exchange) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            ConfiguredObjectRecord configuredObject = this._configuredObjectHelper.createExchangeConfiguredObject(exchange);
            this.storeConfiguredObjectEntry(configuredObject);
        }
    }

    public void removeExchange(Exchange exchange) throws AMQStoreException {
        OperationStatus status;
        UUID id = exchange.getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("public void removeExchange(String name = " + exchange.getName() + ", uuid = " + id + "): called"));
        }
        if ((status = this.removeConfiguredObject(id)) == OperationStatus.NOTFOUND) {
            throw new AMQStoreException("Exchange " + exchange.getName() + " with id " + id + " not found");
        }
    }

    public void bindQueue(Binding binding) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            ConfiguredObjectRecord configuredObject = this._configuredObjectHelper.createBindingConfiguredObject(binding);
            this.storeConfiguredObjectEntry(configuredObject);
        }
    }

    public void unbindQueue(Binding binding) throws AMQStoreException {
        OperationStatus status;
        UUID id = binding.getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("public void unbindQueue(Binding binding = " + binding + ", uuid = " + id + "): called"));
        }
        if ((status = this.removeConfiguredObject(id)) == OperationStatus.NOTFOUND) {
            throw new AMQStoreException("Binding " + binding + " not found");
        }
    }

    public void createQueue(AMQQueue queue) throws AMQStoreException {
        this.createQueue(queue, null);
    }

    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("public void createQueue(AMQQueue queue(" + queue.getName() + "), queue id" + queue.getId() + ", arguments=" + arguments + "): called"));
            }
            ConfiguredObjectRecord configuredObject = this._configuredObjectHelper.createQueueConfiguredObject(queue, arguments);
            this.storeConfiguredObjectEntry(configuredObject);
        }
    }

    public void updateQueue(AMQQueue queue) throws AMQStoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Updating queue: " + queue.getName()));
        }
        try {
            DatabaseEntry key = new DatabaseEntry();
            UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
            keyBinding.objectToEntry(queue.getId(), key);
            DatabaseEntry value = new DatabaseEntry();
            DatabaseEntry newValue = new DatabaseEntry();
            ConfiguredObjectBinding configuredObjectBinding = ConfiguredObjectBinding.getInstance();
            OperationStatus status = this._configuredObjectsDb.get(null, key, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                ConfiguredObjectRecord queueRecord = (ConfiguredObjectRecord)configuredObjectBinding.entryToObject(value);
                ConfiguredObjectRecord newQueueRecord = this._configuredObjectHelper.updateQueueConfiguredObject(queue, queueRecord);
                configuredObjectBinding.objectToEntry(newQueueRecord, newValue);
                status = this._configuredObjectsDb.put(null, key, newValue);
                if (status != OperationStatus.SUCCESS) {
                    throw new AMQStoreException("Error updating queue details within the store: " + status);
                }
            } else if (status != OperationStatus.NOTFOUND) {
                throw new AMQStoreException("Error finding queue details within the store: " + status);
            }
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error updating queue details within the store: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void removeQueue(AMQQueue queue) throws AMQStoreException {
        OperationStatus status;
        UUID id = queue.getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("public void removeQueue(AMQShortString name = " + queue.getName() + ", uuid = " + id + "): called"));
        }
        if ((status = this.removeConfiguredObject(id)) == OperationStatus.NOTFOUND) {
            throw new AMQStoreException("Queue " + queue.getName() + " with id " + id + " not found");
        }
    }

    public void enqueueMessage(com.sleepycat.je.Transaction tx, TransactionLogResource queue, long messageId) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
        QueueEntryKey dd = new QueueEntryKey(queue.getId(), messageId);
        keyBinding.objectToEntry(dd, key);
        DatabaseEntry value = new DatabaseEntry();
        ByteBinding.byteToEntry((byte)0, (DatabaseEntry)value);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Enqueuing message " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + queue.getId() + " in transaction " + tx));
            }
            this._deliveryDb.put(tx, key, value);
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)("Failed to enqueue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error writing enqueued message with id " + messageId + " for queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + queue.getId() + " to database", (Throwable)e);
        }
    }

    public void dequeueMessage(com.sleepycat.je.Transaction tx, TransactionLogResource queue, long messageId) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
        QueueEntryKey queueEntryKey = new QueueEntryKey(queue.getId(), messageId);
        UUID id = queue.getId();
        keyBinding.objectToEntry(queueEntryKey, key);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Dequeue message id " + messageId + " from queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + id));
        }
        try {
            OperationStatus status = this._deliveryDb.delete(tx, key);
            if (status == OperationStatus.NOTFOUND) {
                throw new AMQStoreException("Unable to find message with id " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + id);
            }
            if (status != OperationStatus.SUCCESS) {
                throw new AMQStoreException("Unable to remove message with id " + messageId + " on queue" + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + id);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removed message " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() + " with id " : "") + id + " from delivery db"));
            }
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)("Failed to dequeue message " + messageId + ": " + e.getMessage()), (Throwable)e);
            LOGGER.error((Object)tx);
            throw new AMQStoreException("Error accessing database while dequeuing message: " + e.getMessage(), (Throwable)e);
        }
    }

    private void recordXid(com.sleepycat.je.Transaction txn, long format, byte[] globalId, byte[] branchId, Transaction.Record[] enqueues, Transaction.Record[] dequeues) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        Xid xid = new Xid(format, globalId, branchId);
        XidBinding keyBinding = XidBinding.getInstance();
        keyBinding.objectToEntry(xid, key);
        DatabaseEntry value = new DatabaseEntry();
        PreparedTransaction preparedTransaction = new PreparedTransaction(enqueues, dequeues);
        PreparedTransactionBinding valueBinding = new PreparedTransactionBinding();
        valueBinding.objectToEntry(preparedTransaction, value);
        try {
            this._xidDb.put(txn, key, value);
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)("Failed to write xid: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error writing xid to database", (Throwable)e);
        }
    }

    private void removeXid(com.sleepycat.je.Transaction txn, long format, byte[] globalId, byte[] branchId) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        Xid xid = new Xid(format, globalId, branchId);
        XidBinding keyBinding = XidBinding.getInstance();
        keyBinding.objectToEntry(xid, key);
        try {
            OperationStatus status = this._xidDb.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                throw new AMQStoreException("Unable to find xid");
            }
            if (status != OperationStatus.SUCCESS) {
                throw new AMQStoreException("Unable to remove xid");
            }
        }
        catch (DatabaseException e) {
            LOGGER.error((Object)"Failed to remove xid ", (Throwable)e);
            LOGGER.error((Object)txn);
            throw new AMQStoreException("Error accessing database while removing xid: " + e.getMessage(), (Throwable)e);
        }
    }

    private StoreFuture commitTranImpl(com.sleepycat.je.Transaction tx, boolean syncCommit) throws AMQStoreException {
        StoreFuture result;
        if (tx == null) {
            throw new AMQStoreException("Fatal internal error: transactional is null at commitTran");
        }
        try {
            result = this.commit(tx, syncCommit);
            if (LOGGER.isDebugEnabled()) {
                String transactionType = syncCommit ? "synchronous" : "asynchronous";
                LOGGER.debug((Object)("commitTranImpl completed " + transactionType + " transaction " + tx));
            }
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error commit tx: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void abortTran(com.sleepycat.je.Transaction tx) throws AMQStoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("abortTran called for transaction " + tx));
        }
        try {
            tx.abort();
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error aborting transaction: " + e.getMessage(), (Throwable)e);
        }
    }

    List<Long> getEnqueuedMessages(UUID queueId) throws AMQStoreException {
        Cursor cursor = null;
        try {
            cursor = this._deliveryDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            QueueEntryKey dd = new QueueEntryKey(queueId, 0L);
            QueueEntryBinding keyBinding = QueueEntryBinding.getInstance();
            keyBinding.objectToEntry(dd, key);
            DatabaseEntry value = new DatabaseEntry();
            LinkedList<Long> messageIds = new LinkedList<Long>();
            OperationStatus status = cursor.getSearchKeyRange(key, value, LockMode.DEFAULT);
            dd = (QueueEntryKey)keyBinding.entryToObject(key);
            while (status == OperationStatus.SUCCESS && dd.getQueueId().equals(queueId)) {
                messageIds.add(dd.getMessageId());
                status = cursor.getNext(key, value, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) continue;
                dd = (QueueEntryKey)keyBinding.entryToObject(key);
            }
            LinkedList<Long> linkedList = messageIds;
            return linkedList;
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Database error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException e) {
                    throw new AMQStoreException("Error closing cursor: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public long getNewMessageId() {
        return this._messageId.incrementAndGet();
    }

    protected void addContent(com.sleepycat.je.Transaction tx, long messageId, int offset, ByteBuffer contentBody) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        ContentBinding messageBinding = ContentBinding.getInstance();
        messageBinding.objectToEntry(contentBody.array(), value);
        try {
            OperationStatus status = this._messageContentDb.put(tx, key, value);
            if (status != OperationStatus.SUCCESS) {
                throw new AMQStoreException("Error adding content for message id " + messageId + ": " + status);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Storing content for message " + messageId + " in transaction " + tx));
            }
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error writing AMQMessage with id " + messageId + " to database: " + e.getMessage(), (Throwable)e);
        }
    }

    private void storeMetaData(com.sleepycat.je.Transaction tx, long messageId, StorableMessageMetaData messageMetaData) throws AMQStoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("storeMetaData called for transaction " + tx + ", messageId " + messageId + ", messageMetaData " + messageMetaData));
        }
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        MessageMetaDataBinding messageBinding = MessageMetaDataBinding.getInstance();
        messageBinding.objectToEntry(messageMetaData, value);
        try {
            this._messageMetaDataDb.put(tx, key, value);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Storing message metadata for message id " + messageId + " in transaction " + tx));
            }
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error writing message metadata with id " + messageId + " to database: " + e.getMessage(), (Throwable)e);
        }
    }

    public StorableMessageMetaData getMessageMetaData(long messageId) throws AMQStoreException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("public MessageMetaData getMessageMetaData(Long messageId = " + messageId + "): called"));
        }
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)key);
        DatabaseEntry value = new DatabaseEntry();
        MessageMetaDataBinding messageBinding = MessageMetaDataBinding.getInstance();
        try {
            OperationStatus status = this._messageMetaDataDb.get(null, key, value, LockMode.READ_UNCOMMITTED);
            if (status != OperationStatus.SUCCESS) {
                throw new AMQStoreException("Metadata not found for message with id " + messageId);
            }
            StorableMessageMetaData mdd = (StorableMessageMetaData)messageBinding.entryToObject(value);
            return mdd;
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error reading message metadata for message with id " + messageId + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public int getContent(long messageId, int offset, ByteBuffer dst) throws AMQStoreException {
        DatabaseEntry contentKeyEntry = new DatabaseEntry();
        LongBinding.longToEntry((long)messageId, (DatabaseEntry)contentKeyEntry);
        DatabaseEntry value = new DatabaseEntry();
        ContentBinding contentTupleBinding = ContentBinding.getInstance();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Message Id: " + messageId + " Getting content body from offset: " + offset));
        }
        try {
            int written = 0;
            OperationStatus status = this._messageContentDb.get(null, contentKeyEntry, value, LockMode.READ_UNCOMMITTED);
            if (status == OperationStatus.SUCCESS) {
                byte[] dataAsBytes = (byte[])contentTupleBinding.entryToObject(value);
                int size = dataAsBytes.length;
                if (offset > size) {
                    throw new RuntimeException("Offset " + offset + " is greater than message size " + size + " for message id " + messageId + "!");
                }
                written = size - offset;
                if (written > dst.remaining()) {
                    written = dst.remaining();
                }
                dst.put(dataAsBytes, offset, written);
            }
            return written;
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error getting AMQMessage with id " + messageId + " to database: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public <T extends StorableMessageMetaData> StoredMessage<T> addMessage(T metaData) {
        if (metaData.isPersistent()) {
            return new StoredBDBMessage(this.getNewMessageId(), metaData);
        }
        return new StoredMemoryMessage(this.getNewMessageId(), metaData);
    }

    Database getMetaDataDb() {
        return this._messageMetaDataDb;
    }

    Database getContentDb() {
        return this._messageContentDb;
    }

    Database getDeliveryDb() {
        return this._deliveryDb;
    }

    private void storeConfiguredObjectEntry(ConfiguredObjectRecord configuredObject) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            DatabaseEntry key = new DatabaseEntry();
            UUIDTupleBinding keyBinding = UUIDTupleBinding.getInstance();
            keyBinding.objectToEntry(configuredObject.getId(), key);
            DatabaseEntry value = new DatabaseEntry();
            ConfiguredObjectBinding queueBinding = ConfiguredObjectBinding.getInstance();
            queueBinding.objectToEntry(configuredObject, value);
            try {
                OperationStatus status = this._configuredObjectsDb.put(null, key, value);
                if (status != OperationStatus.SUCCESS) {
                    throw new AMQStoreException("Error writing configured object " + configuredObject + " to database: " + status);
                }
            }
            catch (DatabaseException e) {
                throw new AMQStoreException("Error writing configured object " + configuredObject + " to database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private OperationStatus removeConfiguredObject(UUID id) throws AMQStoreException {
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(id, key);
        try {
            return this._configuredObjectsDb.delete(null, key);
        }
        catch (DatabaseException e) {
            throw new AMQStoreException("Error deleting of configured object with id " + id + " from database", (Throwable)e);
        }
    }

    protected abstract StoreFuture commit(com.sleepycat.je.Transaction var1, boolean var2) throws DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            AbstractBDBMessageStore abstractBDBMessageStore = this;
            synchronized (abstractBDBMessageStore) {
                long newSize = this._totalStoreSize += (long)(2 * delta);
                if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                    this._totalStoreSize = this.getSizeOnDisk();
                    if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                        this._limitBusted = true;
                        this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                    }
                } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                    long oldSize = this._totalStoreSize;
                    this._totalStoreSize = this.getSizeOnDisk();
                    if (oldSize <= this._totalStoreSize) {
                        this.reduceSizeOnDisk();
                        this._totalStoreSize = this.getSizeOnDisk();
                    }
                    if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                        this._limitBusted = false;
                        this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                    }
                }
            }
        }
    }

    private void reduceSizeOnDisk() {
        this._environment.getConfig().setConfigParam("je.env.runCleaner", "false");
        boolean cleaned = false;
        while (this._environment.cleanLog() > 0) {
            cleaned = true;
        }
        if (cleaned) {
            CheckpointConfig force = new CheckpointConfig();
            force.setForce(true);
            this._environment.checkpoint(force);
        }
        this._environment.getConfig().setConfigParam("je.env.runCleaner", "true");
    }

    private long getSizeOnDisk() {
        return this._environment.getStats(null).getTotalLogSize();
    }

    private long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    private long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }

    private void setEnvironmentConfigProperties(EnvironmentConfig envConfig) {
        for (Map.Entry<String, String> configItem : this._envConfigMap.entrySet()) {
            LOGGER.debug((Object)("Setting EnvironmentConfig key " + configItem.getKey() + " to '" + configItem.getValue() + "'"));
            envConfig.setConfigParam(configItem.getKey(), configItem.getValue());
        }
    }

    protected EnvironmentConfig createEnvironmentConfig() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        this.setEnvironmentConfigProperties(envConfig);
        envConfig.setExceptionListener((ExceptionListener)new LoggingAsyncExceptionListener());
        return envConfig;
    }

    protected void closeEnvironmentSafely() {
        try {
            this._environment.close();
        }
        catch (DatabaseException ex) {
            LOGGER.error((Object)"Exception closing store environment", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            LOGGER.error((Object)"Exception closing store environment", (Throwable)ex);
        }
    }

    public void onDelete() {
        File location;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting store " + this._storeLocation));
        }
        if (this._storeLocation != null && (location = new File(this._storeLocation)).exists() && !FileUtils.delete((File)location, (boolean)true)) {
            LOGGER.error((Object)("Cannot delete " + this._storeLocation));
        }
    }

    private class LoggingAsyncExceptionListener
    implements ExceptionListener {
        private LoggingAsyncExceptionListener() {
        }

        public void exceptionThrown(ExceptionEvent event) {
            LOGGER.error((Object)("Asynchronous exception thrown by BDB thread '" + event.getThreadName() + "'"), (Throwable)event.getException());
        }
    }

    private class BDBTransaction
    implements Transaction {
        private com.sleepycat.je.Transaction _txn;
        private int _storeSizeIncrease;

        private BDBTransaction() {
            try {
                this._txn = AbstractBDBMessageStore.this._environment.beginTransaction(null, null);
            }
            catch (DatabaseException e) {
                LOGGER.error((Object)"Exception during transaction begin, closing store environment.", (Throwable)e);
                AbstractBDBMessageStore.this.closeEnvironmentSafely();
                throw new RuntimeException("Exception during transaction begin, store environment closed.", e);
            }
        }

        public void enqueueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
            if (message.getStoredMessage() instanceof StoredBDBMessage) {
                StoredBDBMessage storedMessage = (StoredBDBMessage)message.getStoredMessage();
                storedMessage.store(this._txn);
                this._storeSizeIncrease += storedMessage.getMetaData().getContentSize();
            }
            AbstractBDBMessageStore.this.enqueueMessage(this._txn, queue, message.getMessageNumber());
        }

        public void dequeueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
            AbstractBDBMessageStore.this.dequeueMessage(this._txn, queue, message.getMessageNumber());
        }

        public void commitTran() throws AMQStoreException {
            AbstractBDBMessageStore.this.commitTranImpl(this._txn, true);
            AbstractBDBMessageStore.this.storedSizeChange(this._storeSizeIncrease);
        }

        public StoreFuture commitTranAsync() throws AMQStoreException {
            AbstractBDBMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            return AbstractBDBMessageStore.this.commitTranImpl(this._txn, false);
        }

        public void abortTran() throws AMQStoreException {
            AbstractBDBMessageStore.this.abortTran(this._txn);
        }

        public void removeXid(long format, byte[] globalId, byte[] branchId) throws AMQStoreException {
            AbstractBDBMessageStore.this.removeXid(this._txn, format, globalId, branchId);
        }

        public void recordXid(long format, byte[] globalId, byte[] branchId, Transaction.Record[] enqueues, Transaction.Record[] dequeues) throws AMQStoreException {
            AbstractBDBMessageStore.this.recordXid(this._txn, format, globalId, branchId, enqueues, dequeues);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoredBDBMessage
    implements StoredMessage<StorableMessageMetaData> {
        private final long _messageId;
        private final boolean _isRecovered;
        private StorableMessageMetaData _metaData;
        private volatile SoftReference<StorableMessageMetaData> _metaDataRef;
        private byte[] _data;
        private volatile SoftReference<byte[]> _dataRef;

        StoredBDBMessage(long messageId, StorableMessageMetaData metaData) {
            this(messageId, metaData, false);
        }

        StoredBDBMessage(long messageId, StorableMessageMetaData metaData, boolean isRecovered) {
            this._messageId = messageId;
            this._isRecovered = isRecovered;
            if (!this._isRecovered) {
                this._metaData = metaData;
            }
            this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
        }

        public StorableMessageMetaData getMetaData() {
            StorableMessageMetaData metaData = this._metaDataRef.get();
            if (metaData == null) {
                try {
                    metaData = AbstractBDBMessageStore.this.getMessageMetaData(this._messageId);
                }
                catch (AMQStoreException e) {
                    throw new RuntimeException(e);
                }
                this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public void addContent(int offsetInMessage, ByteBuffer src) {
            src = src.slice();
            if (this._data == null) {
                this._data = new byte[src.remaining()];
                this._dataRef = new SoftReference<byte[]>(this._data);
                src.duplicate().get(this._data);
            } else {
                byte[] oldData = this._data;
                this._data = new byte[oldData.length + src.remaining()];
                this._dataRef = new SoftReference<byte[]>(this._data);
                System.arraycopy(oldData, 0, this._data, 0, oldData.length);
                src.duplicate().get(this._data, oldData.length, src.remaining());
            }
        }

        public int getContent(int offsetInMessage, ByteBuffer dst) {
            byte[] data;
            byte[] byArray = data = this._dataRef == null ? null : this._dataRef.get();
            if (data != null) {
                int length = Math.min(dst.remaining(), data.length - offsetInMessage);
                dst.put(data, offsetInMessage, length);
                return length;
            }
            try {
                return AbstractBDBMessageStore.this.getContent(this._messageId, offsetInMessage, dst);
            }
            catch (AMQStoreException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteBuffer getContent(int offsetInMessage, int size) {
            byte[] data;
            byte[] byArray = data = this._dataRef == null ? null : this._dataRef.get();
            if (data != null) {
                return ByteBuffer.wrap(data, offsetInMessage, size);
            }
            ByteBuffer buf = ByteBuffer.allocate(size);
            int length = this.getContent(offsetInMessage, buf);
            buf.limit(length);
            buf.position(0);
            return buf;
        }

        synchronized void store(com.sleepycat.je.Transaction txn) {
            if (!this.stored()) {
                try {
                    this._dataRef = new SoftReference<byte[]>(this._data);
                    AbstractBDBMessageStore.this.storeMetaData(txn, this._messageId, this._metaData);
                    AbstractBDBMessageStore.this.addContent(txn, this._messageId, 0, this._data == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(this._data));
                }
                catch (DatabaseException e) {
                    throw new RuntimeException(e);
                }
                catch (AMQStoreException e) {
                    throw new RuntimeException(e);
                }
                catch (RuntimeException e) {
                    LOGGER.error((Object)"RuntimeException during store", (Throwable)e);
                    throw e;
                }
                finally {
                    this._metaData = null;
                    this._data = null;
                }
            }
        }

        public synchronized StoreFuture flushToStore() {
            if (!this.stored()) {
                com.sleepycat.je.Transaction txn = AbstractBDBMessageStore.this._environment.beginTransaction(null, null);
                this.store(txn);
                AbstractBDBMessageStore.this.commit(txn, true);
                AbstractBDBMessageStore.this.storedSizeChange(this.getMetaData().getContentSize());
            }
            return StoreFuture.IMMEDIATE_FUTURE;
        }

        public void remove() {
            try {
                int delta = this.getMetaData().getContentSize();
                AbstractBDBMessageStore.this.removeMessage(this._messageId, false);
                AbstractBDBMessageStore.this.storedSizeChange(-delta);
            }
            catch (AMQStoreException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean stored() {
            return this._metaData == null || this._isRecovered;
        }
    }
}

