/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.util.DbBackup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.qpid.util.CommandLineParser;
import org.apache.qpid.util.FileUtils;

public class BDBBackup {
    private static final Logger log = Logger.getLogger(BDBBackup.class);
    private static final Logger console = Logger.getLogger((String)"Console");
    private static final String LOG_FILE_SUFFIX = ".jdb";
    public static final String[][] COMMAND_LINE_SPEC = new String[][]{{"fromdir", "The path to the directory to back the bdb log file from.", "dir", "true"}, {"todir", "The path to the directory to save the backed up bdb log files to.", "dir", "true"}};
    public static final long TIMEOUT = 60000L;

    public static void main(String[] args) {
        Properties options = CommandLineParser.processCommandLine((String[])args, (CommandLineParser)new CommandLineParser(COMMAND_LINE_SPEC), (Properties)System.getProperties());
        try {
            String fromDir = options.getProperty("fromdir");
            String toDir = options.getProperty("todir");
            log.info((Object)"BDBBackup Utility: Starting Hot Backup.");
            BDBBackup bdbBackup = new BDBBackup();
            String[] backedUpFiles = bdbBackup.takeBackupNoLock(fromDir, toDir);
            if (log.isInfoEnabled()) {
                log.info((Object)"BDBBackup Utility: Hot Backup Completed.");
                log.info((Object)(backedUpFiles.length + " file(s) backed-up:"));
                for (String backedUpFile : backedUpFiles) {
                    log.info((Object)backedUpFile);
                }
            }
        }
        catch (Exception e) {
            console.info((Object)("Backup script encountered an error and has failed: " + e.getMessage()));
            log.error((Object)("Backup script got exception: " + e.getMessage()), (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeBackup(String fromdir, String todir, Environment environment) throws DatabaseException {
        DbBackup backupHelper = null;
        try {
            backupHelper = new DbBackup(environment);
            backupHelper.startBackup();
            String[] filesForBackup = backupHelper.getLogFilesInBackupSet();
            for (int i = 0; i < filesForBackup.length; ++i) {
                File sourceFile = new File(fromdir + File.separator + filesForBackup[i]);
                File destFile = new File(todir + File.separator + filesForBackup[i]);
                FileUtils.copy((File)sourceFile, (File)destFile);
            }
        }
        finally {
            if (backupHelper != null) {
                backupHelper.endBackup();
            }
        }
    }

    public String[] takeBackupNoLock(String fromdir, String todir) {
        File fromDirFile;
        if (log.isDebugEnabled()) {
            log.debug((Object)("public void takeBackupNoLock(String fromdir = " + fromdir + ", String todir = " + todir + "): called"));
        }
        if (!(fromDirFile = new File(fromdir)).isDirectory()) {
            throw new IllegalArgumentException("The specified fromdir(" + fromdir + ") must be the directory containing your bdbstore.");
        }
        File toDirFile = new File(todir);
        if (!toDirFile.exists()) {
            toDirFile.mkdirs();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created backup directory:" + toDirFile));
            }
        }
        if (!toDirFile.isDirectory()) {
            throw new IllegalArgumentException("The specified todir(" + todir + ") must be a directory.");
        }
        boolean consistentSet = false;
        FileInputStream[] fileInputStreams = new FileInputStream[]{};
        File[] fileSet = new File[]{};
        long start = System.currentTimeMillis();
        while (!consistentSet) {
            long now;
            fileSet = fromDirFile.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(BDBBackup.LOG_FILE_SUFFIX);
                }
            });
            fileInputStreams = new FileInputStream[fileSet.length];
            if (fileSet.length == 0) {
                throw new RuntimeException("There are no BDB log files to backup in the " + fromdir + " directory.");
            }
            for (int i = 0; i < fileSet.length; ++i) {
                try {
                    fileInputStreams[i] = new FileInputStream(fileSet[i]);
                }
                catch (FileNotFoundException e) {
                    for (int j = 0; j < i; ++j) {
                        if (fileInputStreams[j] == null) continue;
                        try {
                            fileInputStreams[j].close();
                            continue;
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException(ioEx);
                        }
                    }
                    break;
                }
                if (i != fileSet.length - 1) continue;
                consistentSet = true;
            }
            if ((now = System.currentTimeMillis()) - start <= 60000L) continue;
            throw new RuntimeException("Hot backup script failed to complete in 60 seconds.");
        }
        LinkedList<String> backedUpFileNames = new LinkedList<String>();
        for (int j = 0; j < fileSet.length; ++j) {
            File destFile = new File(todir + File.separator + fileSet[j].getName());
            try {
                FileUtils.copy((File)fileSet[j], (File)destFile);
            }
            catch (RuntimeException re) {
                Throwable cause = re.getCause();
                if (cause != null && cause instanceof IOException) {
                    throw new RuntimeException(re.getMessage() + " fromDir:" + fromdir + " toDir:" + toDirFile, cause);
                }
                throw re;
            }
            backedUpFileNames.add(destFile.getName());
            try {
                fileInputStreams[j].close();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return backedUpFileNames.toArray(new String[backedUpFileNames.size()]);
    }

    private Environment createSourceDirEnvironment(String fromdir) throws DatabaseException {
        return new Environment(new File(fromdir), new EnvironmentConfig());
    }
}

