/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.CommitThreadWrapper;

public class BDBMessageStore
extends AbstractBDBMessageStore {
    private static final Logger LOGGER = Logger.getLogger(BDBMessageStore.class);
    public static final String TYPE = "BDB";
    private CommitThreadWrapper _commitThreadWrapper;

    protected void setupStore(File storePath, String name) throws DatabaseException, AMQStoreException {
        super.setupStore(storePath, name);
        this._commitThreadWrapper = new CommitThreadWrapper("Commit-Thread-" + name, this.getEnvironment());
        this._commitThreadWrapper.startCommitThread();
    }

    protected Environment createEnvironment(File environmentPath) throws DatabaseException {
        LOGGER.info((Object)("BDB message store using environment path " + environmentPath.getAbsolutePath()));
        EnvironmentConfig envConfig = this.createEnvironmentConfig();
        try {
            return new Environment(environmentPath, envConfig);
        }
        catch (DatabaseException de) {
            if (de.getMessage().contains("Environment.setAllowCreate is false")) {
                envConfig.setAllowCreate(true);
                return new Environment(environmentPath, envConfig);
            }
            throw de;
        }
    }

    protected void closeInternal() throws Exception {
        this._commitThreadWrapper.stopCommitThread();
        super.closeInternal();
    }

    protected StoreFuture commit(Transaction tx, boolean syncCommit) throws DatabaseException {
        try {
            tx.commitNoSync();
        }
        catch (DatabaseException de) {
            LOGGER.error((Object)"Got DatabaseException on commit, closing environment", (Throwable)de);
            this.closeEnvironmentSafely();
            throw de;
        }
        return this._commitThreadWrapper.commit(tx, syncCommit);
    }

    public String getStoreType() {
        return TYPE;
    }
}

