/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.qpid.framing.FieldTable;

public class FieldTableEncoding {
    private FieldTableEncoding() {
    }

    public static FieldTable readFieldTable(TupleInput tupleInput) throws DatabaseException {
        long length = tupleInput.readLong();
        if (length <= 0L) {
            return null;
        }
        byte[] data = new byte[(int)length];
        tupleInput.readFast(data);
        try {
            return new FieldTable((DataInput)new DataInputStream(new ByteArrayInputStream(data)), length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFieldTable(FieldTable fieldTable, TupleOutput tupleOutput) {
        if (fieldTable == null) {
            tupleOutput.writeLong(0L);
        } else {
            tupleOutput.writeLong(fieldTable.getEncodedSize());
            tupleOutput.writeFast(fieldTable.getDataAsBytes());
        }
    }
}

