/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.util.UUID;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.berkeleydb.entry.PreparedTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedTransactionBinding
extends TupleBinding<PreparedTransaction> {
    public PreparedTransaction entryToObject(TupleInput input) {
        Transaction.Record[] enqueues = this.readRecords(input);
        Transaction.Record[] dequeues = this.readRecords(input);
        return new PreparedTransaction(enqueues, dequeues);
    }

    private Transaction.Record[] readRecords(TupleInput input) {
        Transaction.Record[] records = new Transaction.Record[input.readInt()];
        for (int i = 0; i < records.length; ++i) {
            records[i] = new RecordImpl(new UUID(input.readLong(), input.readLong()), input.readLong());
        }
        return records;
    }

    public void objectToEntry(PreparedTransaction preparedTransaction, TupleOutput output) {
        this.writeRecords(preparedTransaction.getEnqueues(), output);
        this.writeRecords(preparedTransaction.getDequeues(), output);
    }

    private void writeRecords(Transaction.Record[] records, TupleOutput output) {
        if (records == null) {
            output.writeInt(0);
        } else {
            output.writeInt(records.length);
            for (Transaction.Record record : records) {
                UUID id = record.getQueue().getId();
                output.writeLong(id.getMostSignificantBits());
                output.writeLong(id.getLeastSignificantBits());
                output.writeLong(record.getMessage().getMessageNumber());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordImpl
    implements Transaction.Record,
    TransactionLogResource,
    EnqueableMessage {
        private long _messageNumber;
        private UUID _queueId;

        public RecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        public TransactionLogResource getQueue() {
            return this;
        }

        public EnqueableMessage getMessage() {
            return this;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public boolean isPersistent() {
            return true;
        }

        public StoredMessage<?> getStoredMessage() {
            throw new UnsupportedOperationException();
        }

        public UUID getId() {
            return this._queueId;
        }
    }
}

