/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.qpid.server.License;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;

public class ConfiguredObjectFactoryGenerator
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ManagedObjectFactoryConstructor.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(ManagedObjectFactoryConstructor.class)) {
                if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                ExecutableElement constructorElement = (ExecutableElement)element;
                String factoryName = this.generateObjectFactory(filer, constructorElement);
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + e.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String generateObjectFactory(Filer filer, ExecutableElement constructorElement) {
        TypeElement classElement = (TypeElement)constructorElement.getEnclosingElement();
        String factoryName = classElement.getQualifiedName().toString() + "Factory";
        String factorySimpleName = classElement.getSimpleName().toString() + "Factory";
        String objectSimpleName = classElement.getSimpleName().toString();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating factory file for " + classElement.getQualifiedName().toString());
        PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
        try {
            void var12_16;
            JavaFileObject factoryFile = filer.createSourceFile(factoryName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            String[] arr$ = License.LICENSE;
            int len$ = arr$.length;
            boolean bl = false;
            while (var12_16 < len$) {
                String headerLine = arr$[var12_16];
                pw.println(" *" + headerLine);
                ++var12_16;
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(packageElement.getQualifiedName());
            pw.println(";");
            pw.println();
            pw.println("import java.util.Map;");
            pw.println();
            pw.println("import org.apache.qpid.server.model.AbstractConfiguredObjectTypeFactory;");
            pw.println("import org.apache.qpid.server.model.ConfiguredObject;");
            pw.println("import org.apache.qpid.server.plugin.PluggableService;");
            pw.println();
            pw.println("@PluggableService");
            pw.println("public final class " + factorySimpleName + " extends AbstractConfiguredObjectTypeFactory<" + objectSimpleName + ">");
            pw.println("{");
            pw.println("    public " + factorySimpleName + "()");
            pw.println("    {");
            pw.println("        super(" + objectSimpleName + ".class);");
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    protected " + objectSimpleName + " createInstance(final Map<String, Object> attributes, final ConfiguredObject<?>... parents)");
            pw.println("    {");
            pw.print("        return new " + objectSimpleName + "(attributes");
            boolean first = true;
            for (VariableElement variableElement : constructorElement.getParameters()) {
                if (first) {
                    first = false;
                    continue;
                }
                TypeMirror erasureType = this.processingEnv.getTypeUtils().erasure(variableElement.asType());
                pw.print(", getParent(" + erasureType.toString() + ".class,parents)");
            }
            pw.println(");");
            pw.println("    }");
            pw.println("}");
            pw.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write factory file: " + factoryName + " - " + e.getLocalizedMessage());
        }
        return factoryName;
    }
}

